/*
 * Decompiled with CFR 0.152.
 */
package org.riverframework.wrapper.org.openntf.domino;

import java.util.Iterator;
import lotus.domino.NotesException;
import org.openntf.domino.Base;
import org.openntf.domino.DocumentCollection;
import org.openntf.domino.View;
import org.openntf.domino.ViewEntry;
import org.openntf.domino.ViewEntryCollection;
import org.riverframework.RiverException;
import org.riverframework.wrapper.Document;
import org.riverframework.wrapper.DocumentIterator;
import org.riverframework.wrapper.Factory;
import org.riverframework.wrapper.Session;
import org.riverframework.wrapper.org.openntf.domino.DefaultBase;

class DefaultDocumentIterator
extends DefaultBase<Base<?>>
implements DocumentIterator<Base<?>, org.openntf.domino.Document> {
    private Session<org.openntf.domino.Session> _session = null;
    protected Factory<Base<?>> _factory = null;
    private DocumentCollection __documentCollection = null;
    private ViewEntryCollection __viewEntryCollection = null;
    private Iterator<org.openntf.domino.Document> __documentIterator = null;
    private Iterator<ViewEntry> __viewEntryIterator = null;
    private Document<org.openntf.domino.Document> _doc = null;
    private org.openntf.domino.Document __document = null;
    private ViewEntry __viewEntry = null;
    private Type type = null;
    private String objectId = null;

    protected DefaultDocumentIterator(Session<org.openntf.domino.Session> s, DocumentCollection __obj) {
        this.type = Type.COLLECTION;
        this._session = s;
        this._factory = this._session.getFactory();
        this.__documentCollection = __obj;
        this.__documentIterator = this.__documentCollection.iterator();
        this.objectId = DefaultDocumentIterator.calcObjectId(this.__documentCollection);
    }

    protected DefaultDocumentIterator(Session<org.openntf.domino.Session> s, View __obj) {
        this.type = Type.VIEW_ENTRY_COLLECTION;
        this._session = s;
        this._factory = this._session.getFactory();
        this.__viewEntryCollection = __obj.getAllEntries();
        this.__viewEntryIterator = this.__viewEntryCollection.iterator();
        this.objectId = DefaultDocumentIterator.calcObjectId(this.__viewEntryCollection);
    }

    protected DefaultDocumentIterator(Session<org.openntf.domino.Session> s, ViewEntryCollection __obj) {
        this.type = Type.VIEW_ENTRY_COLLECTION;
        this._session = s;
        this._factory = this._session.getFactory();
        this.__viewEntryCollection = __obj;
        this.__viewEntryIterator = this.__viewEntryCollection.iterator();
        this.objectId = DefaultDocumentIterator.calcObjectId(this.__viewEntryCollection);
    }

    private static String internalCalcObjectId(Base<?> __object) {
        String objectId = "";
        if (__object != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(__object.getClass().getName());
            sb.append("**");
            sb.append(__object.hashCode());
            objectId = sb.toString();
        }
        return objectId;
    }

    public static String calcObjectId(DocumentCollection __object) {
        return DefaultDocumentIterator.internalCalcObjectId(__object);
    }

    public static String calcObjectId(ViewEntryCollection __object) {
        return DefaultDocumentIterator.internalCalcObjectId(__object);
    }

    public static String calcObjectId(View __object) {
        return DefaultDocumentIterator.internalCalcObjectId(__object);
    }

    public String getObjectId() {
        return this.objectId;
    }

    private boolean isViewEntryValid(lotus.domino.ViewEntry __ve) {
        lotus.domino.Document __doc;
        block4: {
            if (__ve == null) {
                return true;
            }
            try {
                __doc = __ve.getDocument();
                if (__doc != null) break block4;
                return false;
            }
            catch (NotesException e) {
                throw new RiverException((Exception)((Object)e));
            }
        }
        return !__doc.isDeleted();
    }

    private void updateCurrentDocumentFromViewEntry() {
        while (this.__viewEntryIterator.hasNext() && !this.isViewEntryValid((lotus.domino.ViewEntry)this.__viewEntry)) {
            this.__viewEntry = this.__viewEntryIterator.next();
        }
        this.__document = this.__viewEntry == null ? null : this.__viewEntry.getDocument();
    }

    public boolean hasNext() {
        switch (this.type) {
            case COLLECTION: {
                return this.__documentIterator.hasNext();
            }
            case VIEW_ENTRY_COLLECTION: {
                return this.__viewEntryIterator.hasNext();
            }
        }
        throw new RiverException("Wrong iterator type");
    }

    public Document<org.openntf.domino.Document> next() {
        switch (this.type) {
            case COLLECTION: {
                this.__document = this.__documentIterator.next();
                break;
            }
            case VIEW_ENTRY_COLLECTION: {
                this.__viewEntry = this.__viewEntryIterator.next();
                this.updateCurrentDocumentFromViewEntry();
                break;
            }
            default: {
                throw new RiverException("Wrong iterator type");
            }
        }
        this._doc = this._factory.getDocument((Object)this.__document);
        return this._doc;
    }

    public DocumentIterator<Base<?>, org.openntf.domino.Document> iterator() {
        return this;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public DocumentIterator<Base<?>, org.openntf.domino.Document> deleteAll() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Document doc = (Document)iterator.next();
            doc.delete();
        }
        return this;
    }

    public Base<?> getNativeObject() {
        switch (this.type) {
            case COLLECTION: {
                return this.__documentCollection;
            }
            case VIEW_ENTRY_COLLECTION: {
                return this.__viewEntryCollection;
            }
        }
        throw new RiverException("Wrong iterator type");
    }

    public boolean isOpen() {
        switch (this.type) {
            case COLLECTION: {
                return this.__documentCollection != null;
            }
            case VIEW_ENTRY_COLLECTION: {
                return this.__viewEntryCollection != null;
            }
        }
        throw new RiverException("Wrong iterator type");
    }

    public void close() {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.objectId + ")";
    }

    private static enum Type {
        COLLECTION,
        VIEW_ENTRY_COLLECTION;

    }
}

