/*
 * Decompiled with CFR 0.152.
 */
package org.riverframework.wrapper.org.openntf.domino;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.openntf.domino.Database;
import org.openntf.domino.DateTime;
import org.openntf.domino.EmbeddedObject;
import org.openntf.domino.Item;
import org.riverframework.core.DefaultField;
import org.riverframework.core.Field;
import org.riverframework.utils.Converter;
import org.riverframework.wrapper.Document;
import org.riverframework.wrapper.Session;
import org.riverframework.wrapper.org.openntf.domino.DefaultBase;

class DefaultDocument
extends DefaultBase<org.openntf.domino.Document>
implements Document<org.openntf.domino.Document> {
    protected Session<org.openntf.domino.Session> _session = null;
    protected volatile org.openntf.domino.Document __doc = null;
    private String objectId = null;
    private final String FRAGMENTED_FIELD_ID = "{{RIVER_FRAGMENTED_FIELD}}";
    private final String FRAGMENT_FIELD_NAME_SEPARATOR = "$";
    private final int MAX_FIELD_SIZE = Short.MAX_VALUE;

    protected DefaultDocument(Session<org.openntf.domino.Session> s, org.openntf.domino.Document d) {
        this.__doc = d;
        this._session = s;
        this.objectId = DefaultDocument.calcObjectId(this.__doc);
    }

    public static String calcObjectId(org.openntf.domino.Document __doc) {
        String objectId = "";
        if (__doc != null) {
            Database __database = __doc.getParentDatabase();
            StringBuilder sb = new StringBuilder();
            sb.append(__database.getServer());
            sb.append("**");
            sb.append(__database.getFilePath());
            sb.append("**");
            sb.append(__doc.getUniversalID());
            objectId = sb.toString();
        }
        return objectId;
    }

    public Document<org.openntf.domino.Document> setTable(String table) {
        this.__doc.replaceItemValue("Form", (Object)table);
        return this;
    }

    public String getTable() {
        return this.__doc.getItemValueString("Form");
    }

    public org.openntf.domino.Document getNativeObject() {
        return this.__doc;
    }

    public Document setField(String field, Object value) {
        Vector<Object> temp = null;
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() >= Short.MAX_VALUE) {
                boolean finished = false;
                int size = str.length();
                int block = 0;
                while (!finished) {
                    int start = block * Short.MAX_VALUE;
                    int end = start + Short.MAX_VALUE;
                    if (end > size) {
                        end = size;
                        finished = true;
                    }
                    String substr = str.substring(start, end);
                    String fieldName = String.valueOf(field) + "$" + ++block;
                    Item __item = this.__doc.replaceItemValue(fieldName, (Object)substr);
                    __item.setSummary(false);
                }
                str = "{{RIVER_FRAGMENTED_FIELD}}|" + block;
            }
            temp = new Vector<Object>(1);
            temp.add(str);
        } else if (value instanceof Vector) {
            temp = (Vector<Object>)((Vector)value).clone();
        } else if (value instanceof Collection) {
            temp = new Vector((Collection)value);
        } else if (value instanceof String[]) {
            temp = new Vector<Object>(Arrays.asList((Object[])value));
        } else {
            temp = new Vector(1);
            temp.add(value);
        }
        if (temp.get(0) instanceof Date) {
            int i = 0;
            while (i < temp.size()) {
                org.openntf.domino.Session __session = (org.openntf.domino.Session)this._session.getNativeObject();
                DateTime _date = __session.createDateTime((Date)temp.get(i));
                temp.set(i, _date);
                ++i;
            }
        }
        this.__doc.replaceItemValue(field, temp);
        return this;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public Document<org.openntf.domino.Document> recalc() {
        this.__doc.computeWithForm(true, false);
        return this;
    }

    public Field getField(String field) {
        DefaultField value;
        Vector temp = this.__doc.getItemValue(field);
        DefaultField defaultField = value = temp == null ? new DefaultField() : new DefaultField((Collection)temp);
        if (!value.isEmpty() && value.get(0) instanceof DateTime) {
            int i = 0;
            while (i < value.size()) {
                value.set(i, (Object)((DateTime)value.get(i)).toJavaDate());
                ++i;
            }
        }
        return value;
    }

    public String getFieldAsString(String field) {
        String result;
        Vector value = this.__doc.getItemValue(field);
        String string = result = value.size() > 0 ? Converter.getAsString(value.get(0)) : "";
        if (result.startsWith("{{RIVER_FRAGMENTED_FIELD}}")) {
            String[] params = result.split("\\|");
            int blockNum = Integer.valueOf(params[1]);
            StringBuilder sb = new StringBuilder(Short.MAX_VALUE * blockNum);
            int i = 1;
            while (i <= blockNum) {
                String fragment = this.getFieldAsString(String.valueOf(field) + "$" + i);
                sb.append(fragment);
                ++i;
            }
            result = sb.toString();
        }
        return result;
    }

    public int getFieldAsInteger(String field) {
        Vector value = this.__doc.getItemValue(field);
        int result = value.size() > 0 ? Converter.getAsInteger(value.get(0)) : 0;
        return result;
    }

    public long getFieldAsLong(String field) {
        Vector value = this.__doc.getItemValue(field);
        long result = value.size() > 0 ? Converter.getAsLong(value.get(0)) : 0L;
        return result;
    }

    public double getFieldAsDouble(String field) {
        Vector value = this.__doc.getItemValue(field);
        double result = value.size() > 0 ? Converter.getAsDouble(value.get(0)) : 0.0;
        return result;
    }

    public Date getFieldAsDate(String field) {
        Object temp;
        Vector value = null;
        value = this.__doc.getItemValue(field);
        Object object = temp = value.size() > 0 ? (Object)value.get(0) : null;
        if (temp != null && temp.getClass().getName().endsWith("DateTime")) {
            temp = ((DateTime)temp).toJavaDate();
        }
        Date result = Converter.getAsDate((Object)temp);
        return result;
    }

    public boolean isFieldEmpty(String field) {
        Item __item;
        boolean result = true;
        if (this.__doc.hasItem(field) && (__item = this.__doc.getFirstItem(field)) != null) {
            if (__item.getType() == 1 && !this.__doc.getEmbeddedObjects().isEmpty()) {
                for (EmbeddedObject eo : this.__doc.getEmbeddedObjects()) {
                    if (eo.getType() == 0) continue;
                    result = false;
                    break;
                }
            }
            if (result && __item.getText() != "") {
                result = false;
            }
            Object var3_3 = null;
        }
        return result;
    }

    public boolean hasField(String field) {
        boolean result = this.__doc.hasItem(field);
        return result;
    }

    public Map<String, Field> getFields() {
        HashMap<String, Field> result = null;
        Vector items = null;
        items = this.__doc.getItems();
        result = new HashMap<String, Field>(items.size());
        for (Item __item : items) {
            Vector temp;
            String name = __item.getName();
            int type = __item.getType();
            DefaultField values = null;
            values = type == 1024 || type == 1074 || type == 768 || type == 1075 || type == 1 || type == 1280 ? ((temp = __item.getValues()) == null ? new DefaultField() : new DefaultField((Collection)temp)) : new DefaultField();
            if (values.isEmpty()) {
                values.add((Object)"");
            }
            if (!values.isEmpty() && values.get(0) instanceof DateTime) {
                int i = 0;
                while (i < values.size()) {
                    values.set(i, (Object)((DateTime)values.get(i)).toJavaDate());
                    ++i;
                }
            }
            result.put(name, (Field)values);
        }
        return result;
    }

    public boolean isOpen() {
        return this.__doc != null;
    }

    public boolean isNew() {
        boolean result = this.__doc.isNewNote();
        return result;
    }

    public Document<org.openntf.domino.Document> delete() {
        if (this.__doc != null) {
            this.__doc.removePermanently(true);
            this.__doc = null;
        }
        return this;
    }

    public Document<org.openntf.domino.Document> save() {
        this.__doc.save(true, false);
        return this;
    }

    public void close() {
        this.__doc = null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.objectId + ")";
    }
}

