---
title: KatanaFragmentDelegate -
---
//[android](../../index.md)/[org.rewedigital.katana.android.fragment](../index.md)/[KatanaFragmentDelegate](index.md)



# KatanaFragmentDelegate  
 [androidJvm] public final class [KatanaFragmentDelegate](index.md)<T extends [Fragment](https://developer.android.com/reference/kotlin/androidx/fragment/app/Fragment.html)>

Usually Katana components of Fragments depend on components of the parent Activity.



Since Fragments are instantiated **before** Activities, the component initialization must be delayed until the Activity was created.



The delegate simplifies this procedure a bit. A delegate is for example created in the init block of the Fragment via [fragmentDelegate](../-katana-fragment-delegate-kt/fragment-delegate.md). [onActivityCreated](on-activity-created.md) of the delegate must be called in [Fragment.onActivityCreated](https://developer.android.com/reference/kotlin/androidx/fragment/app/Fragment.html#onactivitycreated). The lambda passed to the delegate is called when [onActivityCreated](on-activity-created.md) was called. Inside the lambda component initialization and dependency injection should be performed.

   


## See also  
  
androidJvm  
  
|  Name|  Summary| 
|---|---|
| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate///PointingToDeclaration/"></a>[fragmentDelegate](../-katana-fragment-delegate-kt/fragment-delegate.md)| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate///PointingToDeclaration/"></a>
| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate///PointingToDeclaration/"></a>[org.rewedigital.katana.android.fragment.KatanaFragment](../-katana-fragment/index.md)| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate///PointingToDeclaration/"></a>
  


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate/KatanaFragmentDelegate/#TypeParam(bounds=[androidx.fragment.app.Fragment])#kotlin.Function3[TypeParam(bounds=[androidx.fragment.app.Fragment]),android.app.Activity,android.os.Bundle?,kotlin.Unit]/PointingToDeclaration/"></a>[KatanaFragmentDelegate](-katana-fragment-delegate.md)| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate/KatanaFragmentDelegate/#TypeParam(bounds=[androidx.fragment.app.Fragment])#kotlin.Function3[TypeParam(bounds=[androidx.fragment.app.Fragment]),android.app.Activity,android.os.Bundle?,kotlin.Unit]/PointingToDeclaration/"></a> [androidJvm] [KatanaFragmentDelegate](index.md)<[T](index.md)>[KatanaFragmentDelegate](-katana-fragment-delegate.md)<T extends [Fragment](https://developer.android.com/reference/kotlin/androidx/fragment/app/Fragment.html)>([T](index.md)[fragment](-katana-fragment-delegate.md), Function3<[T](index.md), [Activity](https://developer.android.com/reference/kotlin/android/app/Activity.html), [Bundle](https://developer.android.com/reference/kotlin/android/os/Bundle.html), [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)>[onInject](-katana-fragment-delegate.md))  <br>   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[androidJvm]  <br>Content  <br>[Boolean](https://developer.android.com/reference/kotlin/java/lang/Boolean.html)[equals](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473)([Object](https://developer.android.com/reference/kotlin/java/lang/Object.html)[other](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473))  <br>  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[androidJvm]  <br>Content  <br>[Integer](https://developer.android.com/reference/kotlin/java/lang/Integer.html)[hashCode](index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473)()  <br>  <br><br><br>
| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate/onActivityCreated/#android.os.Bundle?/PointingToDeclaration/"></a>[onActivityCreated](on-activity-created.md)| <a name="org.rewedigital.katana.android.fragment/KatanaFragmentDelegate/onActivityCreated/#android.os.Bundle?/PointingToDeclaration/"></a>[androidJvm]  <br>Content  <br>final [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)[onActivityCreated](on-activity-created.md)([Bundle](https://developer.android.com/reference/kotlin/android/os/Bundle.html)[savedInstanceState](on-activity-created.md))  <br>  <br>More info  <br>Must be called in [Fragment.onActivityCreated](https://developer.android.com/reference/kotlin/androidx/fragment/app/Fragment.html#onactivitycreated) of Fragment associated with this delegate.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[androidJvm]  <br>Content  <br>[String](https://developer.android.com/reference/kotlin/java/lang/String.html)[toString](index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F606972473)()  <br>  <br><br><br>

