/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.WireSerialization;
import org.revenj.server.ProcessingEngine;
import org.revenj.server.ProcessingResult;
import org.revenj.server.ServerCommandDescription;
import org.revenj.server.commands.ExecuteService;
import org.revenj.server.commands.PersistAggregateRoot;
import org.revenj.server.commands.reporting.AnalyzeOlapCube;
import org.revenj.server.servlet.Utility;

public class StandardServlet
extends HttpServlet {
    private final DomainModel model;
    private final ProcessingEngine engine;
    private final WireSerialization serialization;

    public StandardServlet(DomainModel model, ProcessingEngine engine, WireSerialization serialization) {
        this.model = model;
        this.engine = engine;
        this.serialization = serialization;
    }

    StandardServlet(ServiceLocator locator) {
        this((DomainModel)locator.resolve(DomainModel.class), (ProcessingEngine)locator.resolve(ProcessingEngine.class), (WireSerialization)locator.resolve(WireSerialization.class));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/olap/")) {
            Optional<Class<?>> manifest = Utility.findType(this.model, path, "/olap/", res);
            if (manifest.isPresent()) {
                String name = path.substring("/olap/".length(), path.length());
                String spec = req.getParameter("specification");
                Optional<Object> specification = Utility.specificationFromQuery(name, spec, this.model, req, res);
                if (spec != null && !specification.isPresent()) {
                    return;
                }
                Utility.OlapInfo olapInfo = new Utility.OlapInfo(req);
                AnalyzeOlapCube.Argument<Object> arg = new AnalyzeOlapCube.Argument<Object>(name, spec, specification.orElse(null), olapInfo.dimensions, olapInfo.facts, olapInfo.order, olapInfo.limit, olapInfo.offset);
                Utility.execute(this.engine, req, res, this.serialization, AnalyzeOlapCube.class, arg);
            }
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/persist/")) {
            Optional<Class<?>> manifest = Utility.findType(this.model, path, "/persist/", res);
            if (manifest.isPresent()) {
                String name = path.substring("/persist/".length(), path.length());
                Optional<ArrayList> insert = Utility.deserializeOrBadRequest(this.serialization, req, res, ArrayList.class, manifest.get());
                if (insert.isPresent()) {
                    return;
                }
                PersistAggregateRoot.Argument<Object> arg = new PersistAggregateRoot.Argument<Object>(name, insert.get(), null, null);
                Utility.execute(this.engine, req, res, this.serialization, PersistAggregateRoot.class, arg);
            }
        } else if (path.startsWith("/execute/")) {
            String name = path.substring("/execute/".length(), path.length()).replace('+', '$');
            String argument = Utility.readString((InputStream)req.getInputStream(), req.getCharacterEncoding());
            ExecuteService.Argument<String> arg = new ExecuteService.Argument<String>(name, argument);
            ByteArrayOutputStream os = this.serialization.serialize(arg, "application/json");
            ServerCommandDescription[] scd = new ServerCommandDescription[]{new ServerCommandDescription<String>(null, ExecuteService.class, os.toString("UTF-8"))};
            ProcessingResult<Object> result = this.engine.execute(String.class, Object.class, scd, Utility.toPrincipal(req));
            Utility.returnResponse(req, res, this.serialization, result);
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/persist/")) {
            Optional<Class<?>> manifest = Utility.findType(this.model, path, "/persist/", res);
            if (manifest.isPresent()) {
                String name = path.substring("/persist/".length(), path.length());
                Optional<ArrayList> input = Utility.deserializeOrBadRequest(this.serialization, req, res, ArrayList.class, manifest.get());
                if (input.isPresent()) {
                    return;
                }
                ArrayList<PersistAggregateRoot.Pair<Object>> toUpdate = new ArrayList<PersistAggregateRoot.Pair<Object>>(input.get().size());
                for (Object it : input.get()) {
                    toUpdate.add(new PersistAggregateRoot.Pair<Object>(null, it));
                }
                PersistAggregateRoot.Argument<Object> arg = new PersistAggregateRoot.Argument<Object>(name, null, toUpdate, null);
                Utility.execute(this.engine, req, res, this.serialization, PersistAggregateRoot.class, arg);
            }
        } else if (path.startsWith("/olap/")) {
            Optional<Class<?>> manifest = Utility.findType(this.model, path, "/olap/", res);
            if (manifest.isPresent()) {
                String name = path.substring("/olap/".length(), path.length());
                String spec = req.getParameter("specification");
                Optional<Object> specification = Utility.specificationFromQuery(name, spec, this.model, req, res);
                if (spec != null && !specification.isPresent()) {
                    return;
                }
                Utility.OlapInfo olapInfo = new Utility.OlapInfo(req);
                AnalyzeOlapCube.Argument<Object> arg = new AnalyzeOlapCube.Argument<Object>(name, spec, specification.orElse(null), olapInfo.dimensions, olapInfo.facts, olapInfo.order, olapInfo.limit, olapInfo.offset);
                Utility.execute(this.engine, req, res, this.serialization, AnalyzeOlapCube.class, arg);
            }
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }
}

