/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.WireSerialization;
import org.revenj.server.ProcessingEngine;
import org.revenj.server.ProcessingResult;
import org.revenj.server.ServerCommandDescription;
import org.revenj.server.servlet.Utility;

public class RpcServlet
extends HttpServlet {
    private final ProcessingEngine engine;
    private final WireSerialization serialization;

    public RpcServlet(ProcessingEngine engine, WireSerialization serialization) {
        this.engine = engine;
        this.serialization = serialization;
    }

    RpcServlet(ServiceLocator locator) {
        this((ProcessingEngine)locator.resolve(ProcessingEngine.class), (WireSerialization)locator.resolve(WireSerialization.class));
    }

    private void executeRequest(HttpServletRequest req, HttpServletResponse res, ServletInputStream stream) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null || path.length() < 1) {
            res.sendError(400, "Command not specified");
            return;
        }
        String name = path.substring(1);
        Optional<Class<?>> command = this.engine.findCommand(name);
        if (!command.isPresent()) {
            res.sendError(404, "Unknown command: " + name);
            return;
        }
        String argument = Utility.readString((InputStream)stream, req.getCharacterEncoding());
        ServerCommandDescription[] scd = new ServerCommandDescription[]{new ServerCommandDescription<String>(null, command.get(), argument)};
        ProcessingResult<Object> result = this.engine.execute(String.class, Object.class, scd, Utility.toPrincipal(req));
        Utility.returnResponse(req, res, this.serialization, result);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.executeRequest(req, res, null);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.executeRequest(req, res, req.getInputStream());
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.executeRequest(req, res, req.getInputStream());
    }
}

