/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import com.dslplatform.json.DslJson;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Optional;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.Serialization;
import org.revenj.serialization.WireSerialization;
import org.revenj.serialization.json.DslJsonSerialization;
import org.revenj.serialization.xml.XmlJaxbSerialization;
import org.revenj.server.servlet.JacksonSerialization;
import org.revenj.server.servlet.PassThroughSerialization;
import org.w3c.dom.Element;

final class RevenjSerialization
implements WireSerialization {
    private final DslJsonSerialization json;
    private final XmlJaxbSerialization xml;
    private final PassThroughSerialization passThrough;

    public RevenjSerialization(ServiceLocator locator, XmlJaxbSerialization xml) {
        final JacksonSerialization jackson = new JacksonSerialization(locator, locator.tryResolve(ObjectMapper.class));
        this.json = new DslJsonSerialization(locator, Optional.of(new DslJson.Fallback<ServiceLocator>(){

            public void serialize(Object instance, OutputStream stream) throws IOException {
                jackson.serialize(instance, stream);
            }

            public Object deserialize(ServiceLocator serviceLocator, Type manifest, byte[] body, int size) throws IOException {
                return jackson.deserialize(manifest, body, size);
            }

            public Object deserialize(ServiceLocator serviceLocator, Type manifest, InputStream stream) throws IOException {
                return jackson.deserialize(manifest, stream);
            }
        }));
        this.passThrough = new PassThroughSerialization();
        this.xml = xml;
    }

    @Override
    public String serialize(Object value, OutputStream stream, String accept) throws IOException {
        if (accept != null && accept.startsWith("application/xml")) {
            this.xml.serializeTo(value, stream);
            return "application/xml; charset=UTF-8";
        }
        this.json.serialize(value, stream);
        return "application/json";
    }

    @Override
    public Object deserialize(Type type, byte[] content, int length, String contentType) throws IOException {
        if (contentType != null && contentType.startsWith("application/xml")) {
            ByteArrayInputStream is = new ByteArrayInputStream(content, 0, length);
            return this.xml.deserialize(type, (InputStream)is);
        }
        return this.json.deserialize(type, content, length);
    }

    @Override
    public Object deserialize(Type type, InputStream stream, String contentType) throws IOException {
        if (contentType != null && contentType.startsWith("application/xml")) {
            return this.xml.deserialize(type, stream);
        }
        return this.json.deserialize(type, stream);
    }

    @Override
    public <TFormat> Optional<Serialization<TFormat>> find(Class<TFormat> format) {
        if (Object.class.equals(format)) {
            return Optional.of(this.passThrough);
        }
        if (String.class.equals(format)) {
            return Optional.of(this.json);
        }
        if (Element.class.equals(format)) {
            return Optional.of(this.xml);
        }
        return Optional.empty();
    }
}

