/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.WireSerialization;
import org.revenj.server.ProcessingEngine;
import org.revenj.server.commands.reporting.PopulateReport;
import org.revenj.server.servlet.Utility;

public class ReportingServlet
extends HttpServlet {
    private final DomainModel model;
    private final ProcessingEngine engine;
    private final WireSerialization serialization;

    public ReportingServlet(DomainModel model, ProcessingEngine engine, WireSerialization serialization) {
        this.model = model;
        this.engine = engine;
        this.serialization = serialization;
    }

    ReportingServlet(ServiceLocator locator) {
        this((DomainModel)locator.resolve(DomainModel.class), (ProcessingEngine)locator.resolve(ProcessingEngine.class), (WireSerialization)locator.resolve(WireSerialization.class));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/report/")) {
            String name = path.substring("/report/".length(), path.length());
            Optional manifest = this.model.find(name);
            if (!manifest.isPresent()) {
                res.sendError(400, "Unknown report object: " + name);
                return;
            }
            Optional<Object> report = Utility.objectFromQuery((Class)manifest.get(), req, res);
            if (report.isPresent()) {
                PopulateReport.Argument<Object> arg = new PopulateReport.Argument<Object>(report.get(), name);
                Utility.execute(this.engine, req, res, this.serialization, PopulateReport.class, arg);
            }
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/report/")) {
            Optional<Class<?>> manifest = Utility.findType(this.model, path, "/report/", res);
            if (manifest.isPresent()) {
                String name = path.substring("/report/".length(), path.length());
                Optional<?> report = Utility.deserializeOrBadRequest(this.serialization, manifest.get(), req, res);
                if (!report.isPresent()) {
                    return;
                }
                PopulateReport.Argument arg = new PopulateReport.Argument(report.get(), name);
                Utility.execute(this.engine, req, res, this.serialization, PopulateReport.class, arg);
            }
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }
}

