/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import com.dslplatform.json.XmlConverter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.revenj.TreePath;
import org.revenj.Utils;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.Serialization;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

final class JacksonSerialization
implements Serialization<String> {
    private final ObjectMapper mapper;

    public JacksonSerialization(ServiceLocator locator, Optional<ObjectMapper> jackson) {
        this.mapper = jackson.orElse(new ObjectMapper()).configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setInjectableValues((InjectableValues)new InjectableValues.Std().addValue("__locator", (Object)locator)).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)JacksonSerialization.withCustomSerializers()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    private static SimpleModule withCustomSerializers() {
        Transformer transformer;
        SimpleModule module = new SimpleModule();
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        module.addSerializer(Element.class, (JsonSerializer)new JsonSerializer<Element>(){

            public void serialize(Element element, JsonGenerator gen, SerializerProvider unused) throws IOException {
                StringWriter writer = new StringWriter();
                try {
                    transformer.transform(new DOMSource(element.getOwnerDocument()), new StreamResult(writer));
                }
                catch (TransformerException e) {
                    throw new IOException(e);
                }
                gen.writeString(writer.toString());
            }
        });
        module.addSerializer(Point.class, (JsonSerializer)new JsonSerializer<Point>(){

            public void serialize(Point value, JsonGenerator jg, SerializerProvider unused) throws IOException {
                jg.writeStartObject();
                jg.writeNumberField("X", value.x);
                jg.writeNumberField("Y", value.y);
                jg.writeEndObject();
            }
        });
        module.addSerializer(Point2D.class, (JsonSerializer)new JsonSerializer<Point2D>(){

            public void serialize(Point2D value, JsonGenerator jg, SerializerProvider unused) throws IOException {
                jg.writeStartObject();
                jg.writeNumberField("X", value.getX());
                jg.writeNumberField("Y", value.getY());
                jg.writeEndObject();
            }
        });
        module.addSerializer(Rectangle2D.class, (JsonSerializer)new JsonSerializer<Rectangle2D>(){

            public void serialize(Rectangle2D rect, JsonGenerator jg, SerializerProvider unused) throws IOException {
                jg.writeStartObject();
                jg.writeNumberField("X", rect.getX());
                jg.writeNumberField("Y", rect.getY());
                jg.writeNumberField("Width", rect.getWidth());
                jg.writeNumberField("Height", rect.getHeight());
                jg.writeEndObject();
            }
        });
        module.addSerializer(BufferedImage.class, (JsonSerializer)new JsonSerializer<BufferedImage>(){

            public void serialize(BufferedImage image, JsonGenerator jg, SerializerProvider _unused) throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", baos);
                jg.writeBinary(baos.toByteArray());
            }
        });
        module.addSerializer(TreePath.class, (JsonSerializer)new JsonSerializer<TreePath>(){

            public void serialize(TreePath path, JsonGenerator jg, SerializerProvider _unused) throws IOException {
                jg.writeString(path.toString());
            }
        });
        module.addDeserializer(Element.class, (JsonDeserializer)new JsonDeserializer<Element>(){

            public Element deserialize(JsonParser parser, DeserializationContext unused) throws IOException {
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    byte[] content = parser.getValueAsString().getBytes("UTF-8");
                    return Utils.parse((InputSource)new InputSource(new ByteArrayInputStream(content))).getDocumentElement();
                }
                HashMap map = (HashMap)parser.readValueAs(HashMap.class);
                return map == null ? null : XmlConverter.mapToXml((Map)map);
            }
        });
        module.addDeserializer(Point.class, (JsonDeserializer)new JsonDeserializer<Point>(){

            public Point deserialize(JsonParser parser, DeserializationContext unused) throws IOException {
                JsonNode y;
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String[] parts = parser.getValueAsString().split(",");
                    if (parts.length == 2) {
                        return new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
                    }
                    throw new IOException("Unable to parse \"number,number\" format for point");
                }
                JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
                JsonNode x = tree.get("X");
                if (x == null) {
                    x = tree.get("x");
                }
                if ((y = tree.get("Y")) == null) {
                    y = tree.get("y");
                }
                return new Point(x != null ? x.asInt() : 0, y != null ? y.asInt() : 0);
            }
        });
        module.addDeserializer(Point2D.class, (JsonDeserializer)new JsonDeserializer<Point2D>(){

            public Point2D deserialize(JsonParser parser, DeserializationContext unused) throws IOException {
                JsonNode y;
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String[] parts = parser.getValueAsString().split(",");
                    if (parts.length == 2) {
                        return new Point2D.Double(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]));
                    }
                    throw new IOException("Unable to parse \"number,number\" format for point");
                }
                JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
                JsonNode x = tree.get("X");
                if (x == null) {
                    x = tree.get("x");
                }
                if ((y = tree.get("Y")) == null) {
                    y = tree.get("y");
                }
                return new Point2D.Double(x != null ? x.asDouble() : 0.0, y != null ? y.asDouble() : 0.0);
            }
        });
        module.addDeserializer(Rectangle2D.class, (JsonDeserializer)new JsonDeserializer<Rectangle2D>(){

            public Rectangle2D deserialize(JsonParser parser, DeserializationContext _unused) throws IOException {
                JsonNode height;
                JsonNode width;
                JsonNode y;
                if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    String[] parts = parser.getValueAsString().split(",");
                    if (parts.length == 4) {
                        return new Rectangle2D.Double(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
                    }
                    throw new IOException("Unable to parse \"number,number,number,number\" format for rectangle");
                }
                JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
                JsonNode x = tree.get("X");
                if (x == null) {
                    x = tree.get("x");
                }
                if ((y = tree.get("Y")) == null) {
                    y = tree.get("y");
                }
                if ((width = tree.get("Width")) == null) {
                    width = tree.get("width");
                }
                if ((height = tree.get("Height")) == null) {
                    height = tree.get("height");
                }
                return new Rectangle2D.Double(x != null ? x.asDouble() : 0.0, y != null ? y.asDouble() : 0.0, width != null ? width.asDouble() : 0.0, height != null ? height.asDouble() : 0.0);
            }
        });
        module.addDeserializer(BufferedImage.class, (JsonDeserializer)new JsonDeserializer<BufferedImage>(){

            public BufferedImage deserialize(JsonParser parser, DeserializationContext _unused) throws IOException {
                ByteArrayInputStream is = new ByteArrayInputStream(parser.getBinaryValue());
                return ImageIO.read(is);
            }
        });
        module.addDeserializer(TreePath.class, (JsonDeserializer)new JsonDeserializer<TreePath>(){

            public TreePath deserialize(JsonParser parser, DeserializationContext _unused) throws IOException {
                return TreePath.create((String)parser.getValueAsString());
            }
        });
        return module;
    }

    byte[] serializeAsBytes(Object value) throws IOException {
        return this.mapper.writeValueAsBytes(value);
    }

    void serializeTo(Object value, OutputStream stream) throws IOException {
        this.mapper.writeValue(stream, value);
    }

    public String serialize(Type type, Object value) throws IOException {
        if (value == null) {
            return "null";
        }
        JavaType javaType = this.mapper.getTypeFactory().constructType(type == null ? value.getClass() : type);
        return this.mapper.writerFor(javaType).writeValueAsString(value);
    }

    public void serialize(Object value, OutputStream stream) throws IOException {
        this.mapper.writeValue(stream, value);
    }

    Object deserialize(Type type, byte[] content, int length) throws IOException {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        return this.mapper.readValue(content, 0, length, javaType);
    }

    public Object deserialize(Type type, InputStream stream) throws IOException {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        return this.mapper.readValue(stream, javaType);
    }

    public Object deserialize(Type type, String input) throws IOException {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        return this.mapper.readValue(input, javaType);
    }
}

