/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.serialization.WireSerialization;
import org.revenj.server.ProcessingEngine;
import org.revenj.server.commands.QueueEvent;
import org.revenj.server.commands.SubmitEvent;
import org.revenj.server.commands.search.CheckDomainObject;
import org.revenj.server.commands.search.CountDomainObject;
import org.revenj.server.commands.search.DomainObjectExists;
import org.revenj.server.commands.search.GetDomainObject;
import org.revenj.server.commands.search.SearchDomainObject;
import org.revenj.server.servlet.Utility;

public class DomainServlet
extends HttpServlet {
    private final DomainModel model;
    private final ProcessingEngine engine;
    private final WireSerialization serialization;

    public DomainServlet(DomainModel model, ProcessingEngine engine, WireSerialization serialization) {
        this.model = model;
        this.engine = engine;
        this.serialization = serialization;
    }

    DomainServlet(ServiceLocator locator) {
        this((DomainModel)locator.resolve(DomainModel.class), (ProcessingEngine)locator.resolve(ProcessingEngine.class), (WireSerialization)locator.resolve(WireSerialization.class));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/search/")) {
            Optional<String> name = Utility.findName(this.model, path, "/search/", res);
            if (name.isPresent()) {
                Integer offset;
                Integer limit;
                String spec = req.getParameter("specification");
                Optional<Object> specification = Utility.specificationFromQuery(name.get(), spec, this.model, req, res);
                if (spec != null && !specification.isPresent()) {
                    return;
                }
                List<Map.Entry<String, Boolean>> order = Utility.parseOrder(req.getParameter("order"));
                try {
                    limit = req.getParameter("limit") != null ? Integer.valueOf(Integer.parseInt(req.getParameter("limit"))) : null;
                    offset = req.getParameter("offset") != null ? Integer.valueOf(Integer.parseInt(req.getParameter("offset"))) : null;
                }
                catch (NumberFormatException nfe) {
                    res.sendError(400, "Invalid limit/offset provided: " + nfe.getMessage());
                    return;
                }
                SearchDomainObject.Argument<Object> arg = new SearchDomainObject.Argument<Object>(name.get(), spec, specification.orElse(null), offset, limit, order);
                Utility.execute(this.engine, req, res, this.serialization, SearchDomainObject.class, arg);
            }
        } else if (path.startsWith("/count/")) {
            Optional<String> name = Utility.findName(this.model, path, "/count/", res);
            if (name.isPresent()) {
                String spec = req.getParameter("specification");
                Optional<Object> specification = Utility.specificationFromQuery(name.get(), spec, this.model, req, res);
                if (spec != null && !specification.isPresent()) {
                    return;
                }
                CountDomainObject.Argument<Object> arg = new CountDomainObject.Argument<Object>(name.get(), spec, specification.orElse(null));
                Utility.execute(this.engine, req, res, this.serialization, CountDomainObject.class, arg);
            }
        } else if (path.startsWith("/exists/")) {
            Optional<String> name = Utility.findName(this.model, path, "/exists/", res);
            if (name.isPresent()) {
                String spec = req.getParameter("specification");
                Optional<Object> specification = Utility.specificationFromQuery(name.get(), spec, this.model, req, res);
                if (spec != null && !specification.isPresent()) {
                    return;
                }
                DomainObjectExists.Argument<Object> arg = new DomainObjectExists.Argument<Object>(name.get(), spec, specification.orElse(null));
                Utility.execute(this.engine, req, res, this.serialization, DomainObjectExists.class, arg);
            }
        } else if (path.startsWith("/check/")) {
            Optional<String> name = Utility.findName(this.model, path, "/check/", res);
            if (name.isPresent()) {
                String uri = req.getParameter("uri");
                if (uri == null) {
                    res.sendError(400, "Uri parameter not set. Expecting /module.name?uri=value");
                    return;
                }
                CheckDomainObject.Argument arg = new CheckDomainObject.Argument(name.get(), uri);
                Utility.execute(this.engine, req, res, this.serialization, CheckDomainObject.class, arg);
            }
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/submit/")) {
            String name = path.substring("/submit/".length(), path.length());
            Optional manifest = this.model.find(name);
            if (!manifest.isPresent()) {
                res.sendError(400, "Unknown domain object: " + name);
                return;
            }
            Optional domainEvent = Utility.deserializeOrBadRequest(this.serialization, (Class)manifest.get(), req, res);
            if (!domainEvent.isPresent()) {
                return;
            }
            SubmitEvent.Argument arg = new SubmitEvent.Argument(name, domainEvent.get(), Utility.returnInstance(req));
            Utility.execute(this.engine, req, res, this.serialization, SubmitEvent.class, arg);
        } else if (path.startsWith("/queue/")) {
            String name = path.substring("/queue/".length(), path.length());
            Optional manifest = this.model.find(name);
            if (!manifest.isPresent()) {
                res.sendError(400, "Unknown domain object: " + name);
                return;
            }
            Optional domainEvent = Utility.deserializeOrBadRequest(this.serialization, (Class)manifest.get(), req, res);
            if (!domainEvent.isPresent()) {
                return;
            }
            QueueEvent.Argument arg = new QueueEvent.Argument(name, domainEvent.get());
            Utility.execute(this.engine, req, res, this.serialization, QueueEvent.class, arg);
        } else if (path.startsWith("/find/")) {
            this.findWithArguments(req, res, path);
        } else if (path.startsWith("/search/")) {
            this.searchWithArguments(req, res, path);
        } else if (path.startsWith("/count/")) {
            this.countWithArguments(req, res, path);
        } else if (path.startsWith("/exists/")) {
            this.existsWithArguments(req, res, path);
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.startsWith("/find/")) {
            this.findWithArguments(req, res, path);
        } else if (path.startsWith("/search/")) {
            this.searchWithArguments(req, res, path);
        } else if (path.startsWith("/count/")) {
            this.countWithArguments(req, res, path);
        } else if (path.startsWith("/exists/")) {
            this.existsWithArguments(req, res, path);
        } else {
            res.sendError(405, "Unknown URL path: " + path);
        }
    }

    private void existsWithArguments(HttpServletRequest req, HttpServletResponse res, String path) throws IOException {
        Optional<String> name = Utility.findName(this.model, path, "/exists/", res);
        if (name.isPresent()) {
            this.executeWithSpecification(DomainObjectExists.class, req, res, name.get(), spec -> new DomainObjectExists.Argument<Specification>((String)name.get(), null, (Specification)spec));
        }
    }

    private void countWithArguments(HttpServletRequest req, HttpServletResponse res, String path) throws IOException {
        Optional<String> name = Utility.findName(this.model, path, "/count/", res);
        if (name.isPresent()) {
            this.executeWithSpecification(CountDomainObject.class, req, res, name.get(), spec -> new CountDomainObject.Argument<Specification>((String)name.get(), null, (Specification)spec));
        }
    }

    private void searchWithArguments(HttpServletRequest req, HttpServletResponse res, String path) throws IOException {
        Optional<String> name = Utility.findName(this.model, path, "/search/", res);
        if (name.isPresent()) {
            Integer offset;
            Integer limit;
            List<Map.Entry<String, Boolean>> order = Utility.parseOrder(req.getParameter("order"));
            try {
                limit = req.getParameter("limit") != null ? Integer.valueOf(Integer.parseInt(req.getParameter("limit"))) : null;
                offset = req.getParameter("offset") != null ? Integer.valueOf(Integer.parseInt(req.getParameter("offset"))) : null;
            }
            catch (NumberFormatException nfe) {
                res.sendError(400, "Invalid limit/offset provided: " + nfe.getMessage());
                return;
            }
            this.executeWithSpecification(SearchDomainObject.class, req, res, name.get(), spec -> new SearchDomainObject.Argument<Specification>((String)name.get(), null, (Specification)spec, offset, limit, order));
        }
    }

    private void findWithArguments(HttpServletRequest req, HttpServletResponse res, String path) throws IOException {
        Optional<String> name = Utility.findName(this.model, path, "/find/", res);
        if (name.isPresent()) {
            Optional<String[]> uris = Utility.deserializeOrBadRequest(this.serialization, String[].class, req, res);
            if (!uris.isPresent()) {
                return;
            }
            GetDomainObject.Argument arg = new GetDomainObject.Argument(name.get(), uris.get(), "match".equals(req.getParameter("order")));
            Utility.execute(this.engine, req, res, this.serialization, GetDomainObject.class, arg);
        }
    }

    private void executeWithSpecification(Class<?> target, HttpServletRequest req, HttpServletResponse res, String name, Function<Specification, Object> buildArgument) throws IOException {
        Object arg;
        String spec = req.getParameter("specification");
        if (spec != null) {
            Optional specType = this.model.find(name + '+' + spec);
            if (!specType.isPresent()) {
                specType = this.model.find(spec);
            }
            if (!specType.isPresent()) {
                res.sendError(400, "Couldn't find specification: " + spec);
                return;
            }
            try {
                Specification specification = (Specification)this.serialization.deserialize((Type)specType.get(), (InputStream)req.getInputStream(), req.getContentType());
                arg = buildArgument.apply(specification);
            }
            catch (IOException e) {
                res.sendError(400, "Error deserializing specification. " + e.getMessage());
                return;
            }
        } else {
            arg = buildArgument.apply(null);
        }
        Utility.execute(this.engine, req, res, this.serialization, target, arg);
    }
}

