/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import java.io.IOException;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.WireSerialization;
import org.revenj.server.ProcessingEngine;
import org.revenj.server.commands.crud.Create;
import org.revenj.server.commands.crud.Delete;
import org.revenj.server.commands.crud.Read;
import org.revenj.server.commands.crud.Update;
import org.revenj.server.servlet.Utility;

public class CrudServlet
extends HttpServlet {
    private final DomainModel model;
    private final ProcessingEngine engine;
    private final WireSerialization serialization;

    public CrudServlet(DomainModel model, ProcessingEngine engine, WireSerialization serialization) {
        this.model = model;
        this.engine = engine;
        this.serialization = serialization;
    }

    CrudServlet(ServiceLocator locator) {
        this((DomainModel)locator.resolve(DomainModel.class), (ProcessingEngine)locator.resolve(ProcessingEngine.class), (WireSerialization)locator.resolve(WireSerialization.class));
    }

    private <T> Optional<T> check(HttpServletRequest req, HttpServletResponse res, BiFunction<String, String, T> call) throws IOException {
        String path = req.getPathInfo();
        if (path.length() == 0 || path.charAt(0) != '/') {
            res.sendError(400, "Invalid url path. Expecting /module.name?uri=value");
            return Optional.empty();
        }
        String name = path.substring(1, path.length());
        Optional manifest = this.model.find(name);
        if (!manifest.isPresent()) {
            res.sendError(400, "Unknown domain object: " + name);
            return Optional.empty();
        }
        String uri = req.getParameter("uri");
        if (uri == null) {
            res.sendError(400, "Uri parameter not set. Expecting /module.name?uri=value");
            return Optional.empty();
        }
        return Optional.of(call.apply(name, uri));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Optional<Read.Argument> arg = this.check(req, res, Read.Argument::new);
        if (arg.isPresent()) {
            Utility.execute(this.engine, req, res, this.serialization, Read.class, arg.get());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.length() == 0 || path.charAt(0) != '/') {
            res.sendError(400, "Invalid url path. Expecting /module.name");
            return;
        }
        String name = path.substring(1, path.length());
        Optional manifest = this.model.find(name);
        if (!manifest.isPresent()) {
            res.sendError(400, "Unknown domain object: " + name);
            return;
        }
        Optional instance = Utility.deserializeOrBadRequest(this.serialization, (Class)manifest.get(), req, res);
        if (!instance.isPresent()) {
            return;
        }
        Utility.execute(this.engine, req, res, this.serialization, Create.class, new Create.Argument(name, instance.get(), Utility.returnInstance(req)));
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path.length() == 0 || path.charAt(0) != '/') {
            res.sendError(400, "Invalid url path. Expecting /module.name?uri=value");
            return;
        }
        String name = path.substring(1, path.length());
        Optional manifest = this.model.find(name);
        if (!manifest.isPresent()) {
            res.sendError(400, "Unknown domain object: " + name);
            return;
        }
        String uri = req.getParameter("uri");
        if (uri == null) {
            res.sendError(400, "Uri parameter not set. Expecting /module.name?uri=value");
            return;
        }
        Optional instance = Utility.deserializeOrBadRequest(this.serialization, (Class)manifest.get(), req, res);
        if (!instance.isPresent()) {
            return;
        }
        Utility.execute(this.engine, req, res, this.serialization, Update.class, new Update.Argument(name, uri, instance.get(), Utility.returnInstance(req)));
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Optional<Delete.Argument> arg = this.check(req, res, Delete.Argument::new);
        if (arg.isPresent()) {
            Utility.execute(this.engine, req, res, this.serialization, Delete.class, arg.get());
        }
    }
}

