/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.revenj.Revenj;
import org.revenj.extensibility.Container;
import org.revenj.extensibility.PluginLoader;
import org.revenj.patterns.Generic;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.serialization.WireSerialization;
import org.revenj.serialization.xml.XmlJaxbSerialization;
import org.revenj.server.ProcessingEngine;
import org.revenj.server.servlet.CrudServlet;
import org.revenj.server.servlet.DomainServlet;
import org.revenj.server.servlet.ReportingServlet;
import org.revenj.server.servlet.RevenjSerialization;
import org.revenj.server.servlet.RpcServlet;
import org.revenj.server.servlet.StandardServlet;

public class Application
implements ServletContextListener {
    private Container container;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            InputStream resource = context.getResourceAsStream("/revenj.properties");
            if (resource == null) {
                this.container = Revenj.setup();
            } else {
                Properties props = new Properties();
                props.load(resource);
                this.container = Revenj.setup((Properties)props);
            }
            Properties properties = (Properties)this.container.resolve(Properties.class);
            if ("0".equals(properties.getProperty("revenj.aspectsCount"))) {
                String pluginsPath = properties.getProperty("revenj.pluginsPath");
                if (pluginsPath == null) {
                    throw new IOException("System aspects not configured. Probably an error in the configuration.\nSpecify pluginsPath in Properties file (currently not set).");
                }
                if (!new File(pluginsPath).isDirectory()) {
                    throw new IOException("System aspects not configured. Probably an error in the configuration.\nSpecified pluginsPath: " + pluginsPath + " is not an directory.");
                }
                throw new IOException("System aspects not configured. Probably an error in the configuration.\nCheck if revenj.pluginsPath (" + pluginsPath + ") is correctly set in the Properties file.");
            }
            Application.configure(context, this.container);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setup(Container container) throws Exception {
        Optional plugins = container.tryResolve(PluginLoader.class);
        PermissionManager permissions = (PermissionManager)container.resolve(PermissionManager.class);
        DataSource dataSource = (DataSource)container.resolve(DataSource.class);
        RevenjSerialization serialization = new RevenjSerialization((ServiceLocator)container, (XmlJaxbSerialization)container.resolve(XmlJaxbSerialization.class));
        container.registerInstance(WireSerialization.class, (Object)serialization, false);
        container.registerInstance(new Generic<Serialization<String>>(){}.type, serialization.find(String.class).get(), false);
        container.registerInstance((Object)new ProcessingEngine(container, dataSource, (WireSerialization)serialization, permissions, plugins));
    }

    public static void configure(ServletContext context, Container container) throws Exception {
        Application.setup(container);
        context.addServlet("rpc", (Servlet)new RpcServlet((ServiceLocator)container)).addMapping(new String[]{"/RestApplication.svc/*"});
        context.addServlet("crud", (Servlet)new CrudServlet((ServiceLocator)container)).addMapping(new String[]{"/Crud.svc/*"});
        context.addServlet("domain", (Servlet)new DomainServlet((ServiceLocator)container)).addMapping(new String[]{"/Domain.svc/*"});
        context.addServlet("standard", (Servlet)new StandardServlet((ServiceLocator)container)).addMapping(new String[]{"/Commands.svc/*"});
        context.addServlet("reporting", (Servlet)new ReportingServlet((ServiceLocator)container)).addMapping(new String[]{"/Reporting.svc/*"});
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.container != null) {
            try {
                this.container.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.container = null;
        }
    }
}

