/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.search;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.revenj.database.postgres.jinq.JinqMetaModel;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.Query;
import org.revenj.patterns.SearchableRepository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ReadOnlyServerCommand;

public class SearchDomainObject
implements ReadOnlyServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;
    private final JinqMetaModel jinqModel;

    public SearchDomainObject(DomainModel domainModel, PermissionManager permissions, JinqMetaModel jinqModel) {
        this.domainModel = domainModel;
        this.permissions = permissions;
        this.jinqModel = jinqModel;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        List found;
        SearchableRepository repository;
        Specification specification;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.Name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.Name);
        }
        if (!DataSource.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not a data source: " + arg.Name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.Name);
        }
        if (arg.SpecificationName != null && arg.SpecificationName.length() > 0) {
            Optional specType = this.domainModel.find(arg.Name + '+' + arg.SpecificationName);
            if (!specType.isPresent()) {
                specType = this.domainModel.find(arg.SpecificationName);
            }
            if (!specType.isPresent()) {
                return CommandResult.badRequest("Couldn't find specification: " + arg.SpecificationName);
            }
            try {
                specification = (Specification)input.deserialize((Type)specType.get(), arg.Specification);
            }
            catch (IOException e) {
                return CommandResult.badRequest("Error deserializing specification: " + arg.SpecificationName);
            }
        } else {
            specification = arg.Specification instanceof Specification ? (Specification)arg.Specification : null;
        }
        try {
            repository = (SearchableRepository)locator.resolve(SearchableRepository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        if (arg.Order != null && !arg.Order.isEmpty()) {
            Query query = repository.query(specification);
            for (Map.Entry<String, Boolean> o : arg.Order) {
                Method method;
                try {
                    method = ((Class)manifest.get()).getMethod("get" + o.getKey().substring(0, 1).toUpperCase() + o.getKey().substring(1), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return CommandResult.badRequest("Unable to find getter method for: " + o.getKey());
                }
                if (o.getValue().booleanValue()) {
                    query = query.sortedBy(this.jinqModel.findGetter(method));
                    continue;
                }
                query = query.sortedDescendingBy(this.jinqModel.findGetter(method));
            }
            if (arg.Offset != null) {
                query = query.skip((long)arg.Offset.intValue());
            }
            if (arg.Limit != null) {
                query = query.limit((long)arg.Limit.intValue());
            }
            try {
                found = query.list();
            }
            catch (IOException ex) {
                return CommandResult.badRequest(ex.getMessage());
            }
        }
        found = repository.search(specification, arg.Limit, arg.Offset);
        try {
            return CommandResult.success("Found " + found.size() + " items", output.serialize((Object)found));
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    public static final class Argument<TFormat> {
        public final String Name;
        public final String SpecificationName;
        public final TFormat Specification;
        public final Integer Offset;
        public final Integer Limit;
        public final List<Map.Entry<String, Boolean>> Order;

        public Argument(String name, String specificationName, TFormat specification, Integer offset, Integer limit, List<Map.Entry<String, Boolean>> order) {
            this.Name = name;
            this.SpecificationName = specificationName;
            this.Specification = specification;
            this.Offset = offset;
            this.Limit = limit;
            this.Order = order;
        }
    }
}

