/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.search;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.JsonAttribute;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.Repository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ReadOnlyServerCommand;

public class GetDomainObject
implements ReadOnlyServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public GetDomainObject(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        Repository repository;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.name);
        }
        if (arg.uri == null || arg.uri.length == 0) {
            return CommandResult.badRequest("Uri not specified.");
        }
        if (!Identifiable.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an identifiable: " + arg.name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.name);
        }
        try {
            repository = (Repository)locator.resolve(Repository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.name + ". Reason: " + e.getMessage());
        }
        List found = repository.find(arg.uri);
        if (arg.matchOrder && found.size() > 1) {
            found.sort(new UriComparer(arg.uri));
        }
        try {
            return new CommandResult<Object>(output.serialize((Object)found), "Found " + found.size() + " items", 200);
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    private static class UriComparer
    implements Comparator<AggregateRoot> {
        private final Map<String, Integer> order;

        public UriComparer(String[] uris) {
            this.order = new HashMap<String, Integer>(uris.length);
            for (int i = 0; i < uris.length; ++i) {
                this.order.put(uris[i], i);
            }
        }

        @Override
        public int compare(AggregateRoot left, AggregateRoot right) {
            return this.order.get(left.getURI()) - this.order.get(right.getURI());
        }
    }

    @CompiledJson
    public static final class Argument {
        @JsonAttribute(name="Name", alternativeNames={"name"})
        public final String name;
        @JsonAttribute(name="Uri", alternativeNames={"uri"})
        public final String[] uri;
        @JsonAttribute(name="MatchOrder", alternativeNames={"matchOrder"})
        public final boolean matchOrder;

        public Argument(String name, String[] uri, boolean matchOrder) {
            this.name = name;
            this.uri = uri;
            this.matchOrder = matchOrder;
        }
    }
}

