/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.search;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.SearchableRepository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ReadOnlyServerCommand;

public class DomainObjectExists
implements ReadOnlyServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public DomainObjectExists(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        SearchableRepository repository;
        Specification specification;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.Name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.Name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.Name);
        }
        if (arg.SpecificationName != null && arg.SpecificationName.length() > 0) {
            Optional specType = this.domainModel.find(arg.Name + '+' + arg.SpecificationName);
            if (!specType.isPresent()) {
                specType = this.domainModel.find(arg.SpecificationName);
            }
            if (!specType.isPresent()) {
                return CommandResult.badRequest("Couldn't find specification: " + arg.SpecificationName);
            }
            try {
                specification = (Specification)input.deserialize((Type)specType.get(), arg.Specification);
            }
            catch (IOException e) {
                return CommandResult.badRequest("Error deserializing specification: " + arg.SpecificationName);
            }
        } else {
            specification = arg.Specification instanceof Specification ? (Specification)arg.Specification : null;
        }
        try {
            repository = (SearchableRepository)locator.resolve(SearchableRepository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        boolean found = repository.exists(specification);
        try {
            return CommandResult.success(Boolean.toString(found), output.serialize((Object)found));
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    public static final class Argument<TFormat> {
        public final String Name;
        public final String SpecificationName;
        public final TFormat Specification;

        public Argument(String name, String specificationName, TFormat specification) {
            this.Name = name;
            this.SpecificationName = specificationName;
            this.Specification = specification;
        }
    }
}

