/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.search;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.JsonAttribute;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.Repository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ReadOnlyServerCommand;

public class CheckDomainObject
implements ReadOnlyServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public CheckDomainObject(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        Repository repository;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.name);
        }
        if (arg.uri == null) {
            return CommandResult.badRequest("Uri not specified.");
        }
        if (!Identifiable.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an identifiable: " + arg.name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.name);
        }
        try {
            repository = (Repository)locator.resolve(Repository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.name + ". Reason: " + e.getMessage());
        }
        Optional found = repository.find(arg.uri);
        try {
            return new CommandResult<Object>(output.serialize((Object)found.isPresent()), found.isPresent() ? "Found" : "Not found", 200);
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    @CompiledJson
    public static final class Argument {
        @JsonAttribute(name="Name", alternativeNames={"name"})
        public final String name;
        @JsonAttribute(name="Uri", alternativeNames={"uri"})
        public final String uri;

        public Argument(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }
    }
}

