/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.reporting;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.Report;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ReadOnlyServerCommand;

public class PopulateReport
implements ReadOnlyServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public PopulateReport(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        Report report;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.ReportName);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Couldn't find report type: " + arg.ReportName);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.ReportName);
        }
        if (!Report.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not a report: " + arg.ReportName);
        }
        try {
            report = (Report)input.deserialize(arg.Data, (Class)manifest.get());
        }
        catch (IOException e) {
            return CommandResult.badRequest("Error deserializing report: " + arg.ReportName + ". Reason: " + e.getMessage());
        }
        Object result = report.populate(locator);
        try {
            return CommandResult.success("Report populated", output.serialize(result));
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    public static final class Argument<TFormat> {
        public final TFormat Data;
        public final String ReportName;

        public Argument(TFormat data, String reportName) {
            this.Data = data;
            this.ReportName = reportName;
        }
    }
}

