/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.reporting;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.OlapCubeQuery;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ReadOnlyServerCommand;

public class AnalyzeOlapCube
implements ReadOnlyServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public AnalyzeOlapCube(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        OlapCubeQuery cube;
        Specification specification;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.CubeName);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Couldn't find cube type: " + arg.CubeName);
        }
        if (!OlapCubeQuery.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an olap cube: " + arg.CubeName);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.CubeName);
        }
        if (arg.SpecificationName != null && arg.SpecificationName.length() > 0) {
            Optional specType = this.domainModel.find(arg.CubeName + '+' + arg.SpecificationName);
            if (!specType.isPresent()) {
                specType = this.domainModel.find(arg.SpecificationName);
            }
            if (!specType.isPresent()) {
                return CommandResult.badRequest("Couldn't find specification: " + arg.SpecificationName);
            }
            try {
                specification = (Specification)input.deserialize((Type)specType.get(), arg.Specification);
            }
            catch (IOException e) {
                return CommandResult.badRequest("Error deserializing specification: " + arg.SpecificationName);
            }
        } else {
            specification = arg.Specification instanceof Specification ? (Specification)arg.Specification : null;
        }
        try {
            cube = (OlapCubeQuery)locator.resolve((Type)manifest.get());
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving cube: " + arg.CubeName + ". Reason: " + e.getMessage());
        }
        List<String> dimensions = arg.Dimensions == null ? null : Arrays.asList(arg.Dimensions);
        List<String> facts = arg.Facts == null ? null : Arrays.asList(arg.Facts);
        List found = cube.analyze(dimensions, facts, arg.Order, specification, arg.Limit, arg.Offset);
        try {
            return CommandResult.success("Found " + found.size() + " items", output.serialize((Object)found));
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    public static final class Argument<TFormat> {
        public final String CubeName;
        public final String SpecificationName;
        public final TFormat Specification;
        public final String[] Dimensions;
        public final String[] Facts;
        public final List<Map.Entry<String, Boolean>> Order;
        public final Integer Limit;
        public final Integer Offset;

        public Argument(String cubeName, String specificationName, TFormat specification, String[] dimensions, String[] facts, List<Map.Entry<String, Boolean>> order, Integer limit, Integer offset) {
            this.CubeName = cubeName;
            this.SpecificationName = specificationName;
            this.Specification = specification;
            this.Dimensions = dimensions;
            this.Facts = facts;
            this.Order = order;
            this.Limit = limit;
            this.Offset = offset;
        }
    }
}

