/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.crud;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.JsonAttribute;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.Utils;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.PersistableRepository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ServerCommand;

public final class Delete
implements ServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public Delete(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        PersistableRepository repository;
        Argument arg;
        try {
            ParameterizedType genericType = Utils.makeGenericType(Argument.class, data.getClass(), (Type[])new Type[0]);
            arg = (Argument)input.deserialize((Type)genericType, data);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.name);
        }
        if (!AggregateRoot.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an aggregate root: " + arg.name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.name);
        }
        try {
            repository = (PersistableRepository)locator.resolve(PersistableRepository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.name + ". Reason: " + e.getMessage());
        }
        try {
            Optional found = repository.find(arg.uri);
            if (!found.isPresent()) {
                return CommandResult.badRequest("Can't find " + arg.name + " with uri: " + arg.uri);
            }
            repository.delete((AggregateRoot)found.get());
            return CommandResult.success("Object deleted", output.serialize(found.get()));
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
    }

    @CompiledJson
    public static final class Argument {
        @JsonAttribute(name="Name", alternativeNames={"name"})
        public final String name;
        @JsonAttribute(name="Uri", alternativeNames={"uri"})
        public final String uri;

        public Argument(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }
    }
}

