/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands.crud;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.PersistableRepository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ServerCommand;

public final class Create
implements ServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public Create(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        PersistableRepository repository;
        AggregateRoot instance;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.Name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.Name);
        }
        if (arg.Data == null) {
            return CommandResult.badRequest("Data to create not specified.");
        }
        if (!AggregateRoot.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an aggregate root: " + arg.Name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.Name);
        }
        try {
            instance = (AggregateRoot)input.deserialize((Type)manifest.get(), arg.Data);
        }
        catch (IOException e) {
            return CommandResult.badRequest("Error deserializing provided input for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        try {
            repository = (PersistableRepository)locator.resolve(PersistableRepository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        try {
            repository.insert(instance);
            boolean returnInstance = arg.ReturnInstance == null || arg.ReturnInstance != false;
            return new CommandResult<Object>(output.serialize(returnInstance ? instance : instance.getURI()), "Object created", 201);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
    }

    public static final class Argument<TFormat> {
        public final String Name;
        public final TFormat Data;
        public final Boolean ReturnInstance;

        public Argument(String name, TFormat data, Boolean returnInstance) {
            this.Name = name;
            this.Data = data;
            this.ReturnInstance = returnInstance;
        }
    }
}

