/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.DomainEventStore;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ServerCommand;

public class SubmitEvent
implements ServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public SubmitEvent(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        String uri;
        DomainEventStore store;
        DomainEvent instance;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.Name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.Name);
        }
        if (arg.Data == null) {
            return CommandResult.badRequest("Data to submit not specified.");
        }
        if (!DomainEvent.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an domain event: " + arg.Name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.Name);
        }
        try {
            instance = (DomainEvent)input.deserialize((Type)manifest.get(), arg.Data);
        }
        catch (IOException e) {
            return CommandResult.badRequest("Error deserializing provided input for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        try {
            store = (DomainEventStore)locator.resolve(DomainEventStore.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving event store for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        try {
            uri = store.submit(instance);
        }
        catch (IllegalArgumentException e) {
            return new CommandResult<Object>(null, e.getMessage(), 400);
        }
        try {
            return new CommandResult<Object>(Boolean.TRUE.equals(arg.ReturnInstance) ? output.serialize((Object)instance) : output.serialize((Object)uri), "Event stored", 201);
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    public static final class Argument<TFormat> {
        public final String Name;
        public final TFormat Data;
        public final Boolean ReturnInstance;

        public Argument(String name, TFormat data, Boolean returnInstance) {
            this.Name = name;
            this.Data = data;
            this.ReturnInstance = returnInstance;
        }
    }
}

