/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Optional;
import org.revenj.patterns.DataContext;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ServerCommand;

public class QueueEvent
implements ServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;
    private final DataContext dataContext;

    public QueueEvent(DomainModel domainModel, PermissionManager permissions, DataContext dataContext) {
        this.domainModel = domainModel;
        this.permissions = permissions;
        this.dataContext = dataContext;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        DomainEvent instance;
        Argument arg;
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.Name);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Unable to find specified domain object: " + arg.Name);
        }
        if (arg.Data == null) {
            return CommandResult.badRequest("Data to queue not specified.");
        }
        if (!DomainEvent.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an domain event: " + arg.Name);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.Name);
        }
        try {
            instance = (DomainEvent)input.deserialize((Type)manifest.get(), arg.Data);
        }
        catch (IOException e) {
            return CommandResult.badRequest("Error deserializing provided input for: " + arg.Name + ". Reason: " + e.getMessage());
        }
        this.dataContext.queue(instance);
        return new CommandResult<Object>(null, "Event queued", 202);
    }

    public static final class Argument<TFormat> {
        public final String Name;
        public final TFormat Data;

        public Argument(String name, TFormat data) {
            this.Name = name;
            this.Data = data;
        }
    }
}

