/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.revenj.Utils;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.PersistableRepository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ServerCommand;

public class PersistAggregateRoot
implements ServerCommand {
    private final DomainModel domainModel;
    private final PermissionManager permissions;

    public PersistAggregateRoot(DomainModel domainModel, PermissionManager permissions) {
        this.domainModel = domainModel;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        PersistableRepository repository;
        Argument arg;
        if (data == null) {
            return CommandResult.badRequest("Data to persist not specified.");
        }
        try {
            arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
        }
        catch (IOException e) {
            return CommandResult.badRequest(e.getMessage());
        }
        Optional manifest = this.domainModel.find(arg.RootName);
        if (!manifest.isPresent()) {
            return CommandResult.badRequest("Couldn't find root type: " + arg.RootName);
        }
        if (!AggregateRoot.class.isAssignableFrom((Class)manifest.get())) {
            return CommandResult.badRequest("Specified type is not an aggregate root: " + arg.RootName);
        }
        if (!this.permissions.canAccess((Class)manifest.get(), principal)) {
            return CommandResult.forbidden(arg.RootName);
        }
        if (arg.ToInsert == null && arg.ToUpdate == null && arg.ToDelete == null) {
            return CommandResult.badRequest("Data to persist not specified.");
        }
        List insertData = null;
        ArrayList<AbstractMap.SimpleEntry<Object, Object>> updateData = null;
        List deleteData = null;
        try {
            ArrayList pairs;
            if (arg.ToInsert != null) {
                insertData = (List)input.deserialize(arg.ToInsert, ArrayList.class, (Type)manifest.get(), new Type[0]);
            }
            if (arg.ToUpdate != null && (pairs = (ArrayList)input.deserialize(arg.ToUpdate, ArrayList.class, (Type)Utils.makeGenericType(Pair.class, (Type)((Type)manifest.get()), (Type[])new Type[0]), new Type[0])) != null) {
                ArrayList values;
                updateData = new ArrayList<AbstractMap.SimpleEntry<Object, Object>>(pairs.size());
                for (Pair item : pairs) {
                    if (item.Value == null) continue;
                    updateData.add(new AbstractMap.SimpleEntry(item.Key, item.Value));
                }
                if (updateData.size() != pairs.size() && (values = (ArrayList)input.deserialize(arg.ToUpdate, ArrayList.class, (Type)manifest.get(), new Type[0])) != null) {
                    updateData = new ArrayList(values.size());
                    for (AggregateRoot item : values) {
                        updateData.add(new AbstractMap.SimpleEntry<Object, AggregateRoot>(null, item));
                    }
                }
            }
            if (arg.ToDelete != null) {
                deleteData = (List)input.deserialize(arg.ToDelete, ArrayList.class, (Type)manifest.get(), new Type[0]);
            }
        }
        catch (IOException e) {
            return CommandResult.badRequest("Error deserializing provided input for: " + arg.RootName + ". Reason: " + e.getMessage());
        }
        if (!(insertData != null && insertData.size() != 0 || updateData != null && updateData.size() != 0 || deleteData != null && deleteData.size() != 0)) {
            return CommandResult.badRequest("Data not sent or deserialized unsuccessfully.");
        }
        try {
            repository = (PersistableRepository)locator.resolve(PersistableRepository.class, (Type)manifest.get(), new Type[0]);
        }
        catch (ReflectiveOperationException e) {
            return CommandResult.badRequest("Error resolving repository for: " + arg.RootName + ". Reason: " + e.getMessage());
        }
        try {
            String[] uris = repository.persist((Collection)insertData, updateData, (Collection)deleteData);
            return new CommandResult<Object>(output.serialize((Object)uris), "Data persisted", 200);
        }
        catch (IOException ex) {
            return new CommandResult<Object>(null, ex.getMessage(), 409);
        }
    }

    public static class Pair<T> {
        public final T Key;
        public final T Value;

        public Pair(T key, T value) {
            this.Key = key;
            this.Value = value;
        }
    }

    public static final class Argument<TFormat> {
        public final String RootName;
        public final TFormat ToInsert;
        public final TFormat ToUpdate;
        public final TFormat ToDelete;

        public Argument(String rootName, TFormat toInsert, TFormat toUpdate, TFormat toDelete) {
            this.RootName = rootName;
            this.ToInsert = toInsert;
            this.ToUpdate = toUpdate;
            this.ToDelete = toDelete;
        }
    }
}

