/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.server.commands;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Arrays;
import java.util.Optional;
import org.revenj.patterns.ServiceLocator;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.server.CommandResult;
import org.revenj.server.ServerCommand;
import org.revenj.server.ServerService;

public class ExecuteService
implements ServerCommand {
    private final ClassLoader loader;
    private final PermissionManager permissions;

    public ExecuteService(ClassLoader loader, PermissionManager permissions) {
        this.loader = loader;
        this.permissions = permissions;
    }

    @Override
    public <TInput, TOutput> CommandResult<TOutput> execute(ServiceLocator locator, Serialization<TInput> input, Serialization<TOutput> output, TInput data, Principal principal) {
        ServerService service;
        Object argument;
        block16: {
            Class<?> manifest;
            Argument arg;
            try {
                arg = (Argument)input.deserialize(data, Argument.class, data.getClass(), new Type[0]);
            }
            catch (IOException e) {
                return CommandResult.badRequest(e.getMessage());
            }
            try {
                manifest = Class.forName(arg.Name, true, this.loader);
            }
            catch (ClassNotFoundException e) {
                return CommandResult.badRequest("Unable to find specified service: " + arg.Name);
            }
            if (!ServerService.class.isAssignableFrom(manifest)) {
                return CommandResult.badRequest("Object: " + arg.Name + " is not a valid service.");
            }
            Optional<Method> method = Arrays.stream(manifest.getDeclaredMethods()).filter(it -> "execute".equals(it.getName()) && it.getGenericParameterTypes().length == 1).findFirst();
            if (!method.isPresent()) {
                return CommandResult.badRequest("Object: " + arg.Name + " is not a valid service.");
            }
            if (!this.permissions.canAccess(manifest, principal)) {
                return CommandResult.forbidden(arg.Name);
            }
            Class<?> argumentType = method.get().getParameterTypes()[0];
            try {
                argument = input.deserialize(arg.Data, argumentType);
            }
            catch (IOException e) {
                return CommandResult.badRequest(e.getMessage());
            }
            service = null;
            try {
                service = (ServerService)locator.resolve(manifest);
            }
            catch (ReflectiveOperationException e) {
                for (Constructor<?> ctor : manifest.getConstructors()) {
                    try {
                        service = (ServerService)ExecuteService.create(locator, ctor);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                if (service != null) break block16;
                return new CommandResult<Object>(null, "Unable to create an instance of: " + manifest, 500);
            }
        }
        Object result = service.execute(argument);
        try {
            return CommandResult.success("Service executed", output.serialize(result));
        }
        catch (IOException e) {
            return new CommandResult<Object>(null, "Error serializing result.", 500);
        }
    }

    private static <T> T create(ServiceLocator locator, Constructor<T> ctor) throws ReflectiveOperationException {
        Type[] types = ctor.getGenericParameterTypes();
        Object[] dependencies = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            dependencies[i] = locator.resolve(types[i]);
        }
        return ctor.newInstance(dependencies);
    }

    public static final class Argument<TFormat> {
        public final String Name;
        public final TFormat Data;

        public Argument(String name, TFormat data) {
            this.Name = name;
            this.Data = data;
        }
    }
}

