/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Optional;
import org.revenj.Utils;
import org.revenj.serialization.Serialization;

public interface WireSerialization {
    public String serialize(Object var1, OutputStream var2, String var3) throws IOException;

    default public ByteArrayOutputStream serialize(Object value, String accept) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.serialize(value, os, accept);
        return os;
    }

    public Object deserialize(Type var1, byte[] var2, int var3, String var4) throws IOException;

    public Object deserialize(Type var1, InputStream var2, String var3) throws IOException;

    default public <T> T deserialize(byte[] content, int length, String contentType, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, content, length, contentType);
    }

    default public <T> T deserialize(byte[] content, String contentType, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, content, content.length, contentType);
    }

    default public <T> T deserialize(InputStream stream, String contentType, Class<T> manifest) throws IOException {
        return (T)this.deserialize(manifest, stream, contentType);
    }

    default public <T> T deserialize(byte[] content, int length, String contentType, Class<T> container, Type argument, Type ... arguments) throws IOException {
        return (T)this.deserialize(Utils.makeGenericType(container, (Type)argument, (Type[])arguments), content, length, contentType);
    }

    default public <T> T deserialize(InputStream stream, String contentType, Class<T> container, Type argument, Type ... arguments) throws IOException {
        return (T)this.deserialize(Utils.makeGenericType(container, (Type)argument, (Type[])arguments), stream, contentType);
    }

    public <TFormat> Optional<Serialization<TFormat>> find(Class<TFormat> var1);
}

