/*
 * Decompiled with CFR 0.152.
 */
package org.restnext.security;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.xml.bind.JAXBException;
import org.restnext.core.classpath.ClasspathRegister;
import org.restnext.core.http.Request;
import org.restnext.core.jaxb.Jaxb;
import org.restnext.security.Security;
import org.restnext.security.SecurityWatcher;
import org.restnext.security.jaxb.Securities;
import org.restnext.util.FileUtils;
import org.restnext.util.SystemPropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.joegreen.lambdaFromString.LambdaCreationException;
import pl.joegreen.lambdaFromString.LambdaFactory;
import pl.joegreen.lambdaFromString.LambdaFactoryConfiguration;
import pl.joegreen.lambdaFromString.TypeReference;

public final class SecurityScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityScanner.class);
    public static final Path DEFAULT_SECURITY_DIR = SystemPropertyUtils.getPath((String)"user.dir", (String[])new String[]{"security"});
    private final Security security;
    private final Jaxb securityJaxb;
    private final Path securityDirectory;
    private final Map<Path, Map<Path, Set<Security.Mapping>>> securityJarFilesMap = new HashMap<Path, Map<Path, Set<Security.Mapping>>>();
    private LambdaFactory lambdaFactory;

    public SecurityScanner(Security security) {
        this(security, DEFAULT_SECURITY_DIR);
    }

    public SecurityScanner(Security security, Path securityDirectory) {
        this.security = Objects.requireNonNull(security, "security");
        this.securityDirectory = Objects.requireNonNull(securityDirectory, "securityDirectory");
        this.securityJaxb = new Jaxb("security.xsd", new Class[]{Securities.class});
        new Thread((Runnable)new SecurityWatcher(this), "security-dir-watcher").start();
    }

    private void createLambda(Set<Path> jars) {
        String classpath = SystemPropertyUtils.get((String)"java.class.path");
        StringJoiner compilationClassPathJoiner = new StringJoiner(":").add(classpath);
        jars.forEach(jar -> {
            ClasspathRegister.addPath((Path)jar);
            compilationClassPathJoiner.add(jar.toAbsolutePath().toString());
        });
        this.lambdaFactory = LambdaFactory.get((LambdaFactoryConfiguration)LambdaFactoryConfiguration.get().withCompilationClassPath(compilationClassPathJoiner.toString()).withImports(new Class[]{Request.class}));
        jars.forEach(this::lookupSecurityFiles);
    }

    public void scan() {
        this.createLambda(FileUtils.listChildren((Path)this.securityDirectory, (String)"*.jar"));
    }

    void scan(Path jar) {
        this.createLambda(Collections.singleton(jar));
    }

    void remove() {
        FileUtils.listChildren((Path)this.securityDirectory, (String)"*.jar").forEach(this::remove);
    }

    void remove(Path jar) {
        this.securityJarFilesMap.entrySet().removeIf(jarEntry -> {
            boolean unregister = ((Path)jarEntry.getKey()).equals(jar.getFileName());
            if (unregister) {
                ((Map)jarEntry.getValue()).forEach((file, securityMappings) -> securityMappings.forEach(this.security::unregister));
            }
            return unregister;
        });
    }

    Path getSecurityDirectory() {
        return this.securityDirectory;
    }

    private void lookupSecurityFiles(Path jar) {
        try (FileSystem fs = FileSystems.newFileSystem(jar, null);){
            Path securityDirectory = fs.getPath("/META-INF/security/", new String[0]);
            if (Files.exists(securityDirectory, new LinkOption[0])) {
                Set securityFiles = FileUtils.deepListChildren((Path)securityDirectory, (String)"*.xml");
                this.securityJarFilesMap.put(jar.getFileName(), this.readAll(securityFiles));
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not constructs a new fileSystem to access the contents of the file {} as a file system.", (Object)jar, (Object)e);
        }
    }

    private Map<Path, Set<Security.Mapping>> readAll(Set<Path> securityFiles) {
        HashMap securityFileMappings = new HashMap(securityFiles.size());
        securityFiles.forEach(s -> securityFileMappings.put(s, this.read((Path)s)));
        return Collections.unmodifiableMap(new HashMap(securityFileMappings));
    }

    private Set<Security.Mapping> read(Path securityFile) {
        HashSet<Security.Mapping> mappings = new HashSet<Security.Mapping>();
        try (InputStream is = Files.newInputStream(securityFile, new OpenOption[0]);){
            Securities securities = (Securities)this.securityJaxb.unmarshal(is, Securities.class);
            for (Securities.Security security : securities.getSecurity()) {
                String uri = security.getPath();
                Boolean enable = security.getEnable();
                Function provider = (Function)this.lambdaFactory.createLambda(security.getProvider(), (TypeReference)new TypeReference<Function<Request, Boolean>>(){});
                Security.Mapping mapping = this.security.getSecurityMapping(uri);
                if (mapping == null || !mapping.isEnable()) {
                    mapping = Security.Mapping.uri(uri, provider).enable(enable).build();
                    this.security.register(mapping);
                    mappings.add(mapping);
                    continue;
                }
                LOGGER.warn("Ignoring the registration of the uri {} of the security file {} in the fileSystem {}, because it was already registered", new Object[]{uri, securityFile, securityFile.getFileSystem()});
            }
        }
        catch (IOException | JAXBException | LambdaCreationException e) {
            LOGGER.error("Could not read the security file '{}'", (Object)securityFile, (Object)e);
        }
        return Collections.unmodifiableSet(new HashSet(mappings));
    }
}

