/*
 * Decompiled with CFR 0.152.
 */
package org.restnext.security;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.restnext.core.http.Request;
import org.restnext.core.url.UrlMatcher;
import org.restnext.core.url.UrlPattern;
import org.restnext.core.url.UrlRegex;
import org.restnext.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Security {
    INSTANCE;

    private static final Logger LOGGER;
    private final Map<String, Mapping> registry = new TreeMap<String, Mapping>(String.CASE_INSENSITIVE_ORDER);

    public static boolean checkAuthorization(Request request) {
        Objects.requireNonNull(request, "request");
        return Optional.ofNullable(INSTANCE.getSecurityMapping(request.getUri().toString())).filter(Mapping::isEnable).map(securityMapping -> securityMapping.getSecurityProvider().apply(request)).orElse(true);
    }

    public Mapping getSecurityMapping(String uri) {
        for (Mapping securityMapping : this.registry.values()) {
            if (!securityMapping.getUrlMatcher().matches(uri)) continue;
            return securityMapping;
        }
        return null;
    }

    public final void register(Mapping securityMapping) {
        Objects.requireNonNull(securityMapping, "securityMapping");
        String uri = securityMapping.getUri();
        Mapping securityMappingRegistered = this.registry.get(uri);
        if (securityMappingRegistered == null || !securityMappingRegistered.isEnable()) {
            this.registry.put(uri, securityMapping);
            LOGGER.debug("The security uri '{}' was registered.", (Object)uri);
        } else {
            LOGGER.warn("The security uri '{}' is already registered.", (Object)uri);
        }
    }

    public void unregister(Mapping mapping) {
        this.unregister(mapping.getUri());
    }

    public void unregister(String uri) {
        if (this.getSecurityMapping(Objects.requireNonNull(uri, "uri")) != null) {
            this.registry.remove(uri);
            LOGGER.debug("The security uri {} was unregistered", (Object)uri);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(Security.class);
    }

    public static final class Mapping {
        private final String uri;
        private final boolean enable;
        private final UrlMatcher urlMatcher;
        private final Function<Request, Boolean> securityProvider;

        private Mapping(Builder builder) {
            this.uri = builder.uri;
            this.enable = builder.enable;
            this.urlMatcher = builder.urlMatcher;
            this.securityProvider = builder.provider;
        }

        public static Builder uri(String uri, Function<Request, Boolean> provider) {
            return new Builder(uri, provider);
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public UrlMatcher getUrlMatcher() {
            return this.urlMatcher;
        }

        public Function<Request, Boolean> getSecurityProvider() {
            return this.securityProvider;
        }

        public static final class Builder {
            private final String uri;
            private final UrlMatcher urlMatcher;
            private final Function<Request, Boolean> provider;
            private boolean enable = true;

            public Builder(String uri, Function<Request, Boolean> provider) {
                this.uri = UriUtils.normalize((String)Objects.requireNonNull(uri, "uri"));
                this.provider = Objects.requireNonNull(provider, "provider");
                this.urlMatcher = UriUtils.isPathParamUri((String)this.uri) ? new UrlPattern(this.uri) : new UrlRegex(this.uri);
            }

            public Builder enable(Boolean enable) {
                if (enable != null) {
                    this.enable = enable;
                }
                return this;
            }

            public Mapping build() {
                return new Mapping(this);
            }
        }
    }
}

