/*
 * Decompiled with CFR 0.152.
 */
package org.restnext.security;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import org.restnext.security.SecurityScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SecurityWatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityWatcher.class);
    private final SecurityScanner securityScanner;

    SecurityWatcher(SecurityScanner securityScanner) {
        Objects.requireNonNull(securityScanner, "Security scanner must not be null");
        this.securityScanner = securityScanner;
    }

    @Override
    public void run() {
        this.watch();
    }

    private void watch() {
        try (FileSystem fs = FileSystems.getDefault();
             WatchService ws = fs.newWatchService();){
            WatchKey key;
            boolean valid;
            Path securityDirectory = this.securityScanner.getSecurityDirectory();
            securityDirectory.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            PathMatcher jarPathMatcher = fs.getPathMatcher("glob:*.jar");
            LOG.info("Watching security directory for changes - {}", (Object)securityDirectory);
            do {
                key = ws.take();
                for (WatchEvent<?> we : key.pollEvents()) {
                    WatchEvent.Kind<?> wek = we.kind();
                    Path parent = (Path)key.watchable();
                    Path filename = (Path)we.context();
                    if (StandardWatchEventKinds.OVERFLOW.equals(wek)) continue;
                    Path file = parent.resolve(filename);
                    boolean isJarFile = jarPathMatcher.matches(filename);
                    if (!isJarFile) continue;
                    if (StandardWatchEventKinds.ENTRY_CREATE.equals(wek) || StandardWatchEventKinds.ENTRY_MODIFY.equals(wek)) {
                        this.securityScanner.scan(file);
                        continue;
                    }
                    if (!StandardWatchEventKinds.ENTRY_DELETE.equals(wek)) continue;
                    this.securityScanner.remove(file);
                }
            } while (valid = key.reset());
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Could not watch security directory for changes", (Throwable)e);
        }
    }
}

