/*
 * Decompiled with CFR 0.152.
 */
package org.restnext.security;

import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.restnext.core.classpath.ClasspathRegister;
import org.restnext.core.http.codec.Request;
import org.restnext.security.Security;
import org.restnext.security.SecurityWatcher;
import org.restnext.util.FileUtils;
import org.restnext.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.joegreen.lambdaFromString.LambdaFactory;
import pl.joegreen.lambdaFromString.LambdaFactoryConfiguration;
import pl.joegreen.lambdaFromString.TypeReference;

public final class SecurityScanner {
    private static final Logger log = LoggerFactory.getLogger(SecurityScanner.class);
    public static final Path DEFAULT_SECURITY_DIR = Paths.get(SystemPropertyUtil.get((String)"user.dir"), "security");
    private final Security security;
    private final Path securityDirectory;
    private final Map<Path, Map<Path, Set<String>>> jarSecurityFileMap = new HashMap<Path, Map<Path, Set<String>>>();
    private LambdaFactory lambdaFactory;

    public SecurityScanner(Security security) {
        this(security, DEFAULT_SECURITY_DIR);
    }

    public SecurityScanner(Security security, Path securityDirectory) {
        Objects.requireNonNull(security, "Security must not be null");
        Objects.requireNonNull(securityDirectory, "Security directory must not be null");
        this.security = security;
        this.securityDirectory = securityDirectory;
        new Thread((Runnable)new SecurityWatcher(this), "security-dir-watcher").start();
    }

    public void scan() {
        this.createLambda(FileUtils.listChildren((Path)this.securityDirectory, (String)"*.jar"));
    }

    void scan(Path jar) {
        this.createLambda(Collections.singleton(jar));
    }

    void remove() {
        FileUtils.listChildren((Path)this.securityDirectory, (String)"*.jar").forEach(this::remove);
    }

    void remove(Path jar) {
        Iterator<Map.Entry<Path, Map<Path, Set<String>>>> iterator = this.jarSecurityFileMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Path, Map<Path, Set<String>>> jarEntry = iterator.next();
            Path jarfileNameRegistered = jarEntry.getKey();
            if (!jarfileNameRegistered.equals(jar.getFileName())) continue;
            for (Map.Entry<Path, Set<String>> securityFileEntry : jarEntry.getValue().entrySet()) {
                securityFileEntry.getValue().forEach(this.security::unregister);
                iterator.remove();
            }
        }
    }

    Path getSecurityDirectory() {
        return this.securityDirectory;
    }

    private void createLambda(Set<Path> jars) {
        String classpath = SystemPropertyUtil.get((String)"java.class.path");
        StringJoiner compilationClassPathJoiner = new StringJoiner(":").add(classpath);
        jars.forEach(jar -> {
            ClasspathRegister.addPath((Path)jar);
            compilationClassPathJoiner.add(jar.toAbsolutePath().toString());
        });
        this.lambdaFactory = LambdaFactory.get((LambdaFactoryConfiguration)LambdaFactoryConfiguration.get().withCompilationClassPath(compilationClassPathJoiner.toString()).withImports(new Class[]{Request.class}));
        jars.forEach(this::lookupSecurityFiles);
    }

    private void lookupSecurityFiles(Path jar) {
        try (FileSystem fs = FileSystems.newFileSystem(jar, null);){
            Path internalSecurityDir = fs.getPath("/META-INF/security/", new String[0]);
            if (Files.exists(internalSecurityDir, new LinkOption[0])) {
                Set internalSecurityFiles = FileUtils.listChildren((Path)internalSecurityDir, (String)"*.json");
                HashMap securityFileUriMap = new HashMap();
                internalSecurityFiles.forEach(securityFile -> {
                    Path securityFilename = securityFile.getFileName();
                    Set securityUris = (Set)securityFileUriMap.get(securityFilename);
                    if (securityUris == null) {
                        securityFileUriMap.put(securityFilename, this.readAndRegister((Path)securityFile));
                    } else {
                        log.warn("Duplicated security file {} found in the same jar {}", securityFile, (Object)jar);
                    }
                });
                this.jarSecurityFileMap.put(jar.getFileName(), securityFileUriMap);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Set<String> readAndRegister(Path securityFile) {
        HashSet<String> registeredUris = new HashSet<String>();
        try (InputStream is = Files.newInputStream(securityFile, new OpenOption[0]);){
            Metadata[] securitiesMetadata;
            for (Metadata securityMetadata : securitiesMetadata = (Metadata[])JsonUtils.fromJson((InputStream)is, Metadata[].class)) {
                String uri = securityMetadata.getUri();
                String provider = securityMetadata.getProvider();
                if (uri == null && provider == null) continue;
                boolean enable = securityMetadata.isEnable();
                Function securityProvider = (Function)this.lambdaFactory.createLambdaUnchecked(provider, (TypeReference)new TypeReference<Function<Request, Boolean>>(){});
                boolean uriAlreadyRegistered = false;
                Path jarFilenameRegistered = null;
                Path securityFilenameRegistered = null;
                for (Map.Entry<Path, Map<Path, Set<String>>> jarEntry : this.jarSecurityFileMap.entrySet()) {
                    jarFilenameRegistered = jarEntry.getKey();
                    for (Map.Entry<Path, Set<String>> securityFileEntry : jarEntry.getValue().entrySet()) {
                        securityFilenameRegistered = securityFileEntry.getKey();
                        uriAlreadyRegistered = !securityFilenameRegistered.equals(securityFile.getFileName()) && securityFileEntry.getValue().contains(uri);
                    }
                }
                if (!uriAlreadyRegistered) {
                    this.security.register(Security.Mapping.uri(uri, securityProvider).enable(enable).build());
                    registeredUris.add(uri);
                    continue;
                }
                log.warn("Uri {} already registered through the security file {} inside the jar {}", new Object[]{uri, securityFilenameRegistered, jarFilenameRegistered});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return registeredUris;
    }

    private static final class Metadata {
        private String uri;
        private String provider;
        private boolean enable;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }
}

