/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.resthub.web.springmvc.router.HTTPRequestAdapter;
import org.resthub.web.springmvc.router.Router;
import org.resthub.web.springmvc.router.exceptions.ActionNotFoundException;
import org.resthub.web.springmvc.router.support.RouterHandler;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.web.method.HandlerMethod;

public class RouterHandlerResolver {
    private Map<String, Object> cachedControllers = new LinkedHashMap<String, Object>();
    private final Map<String, HandlerMethod> cachedHandlers = new LinkedHashMap<String, HandlerMethod>();

    public void setCachedControllers(Map<String, Object> controllers) {
        for (String key : controllers.keySet()) {
            this.cachedControllers.put(key.toLowerCase(), controllers.get(key));
        }
    }

    public HandlerMethod resolveHandler(Router.Route route, String fullAction, HTTPRequestAdapter req) throws ActionNotFoundException {
        HandlerMethod handlerMethod;
        if (this.cachedHandlers.containsKey(fullAction)) {
            handlerMethod = this.cachedHandlers.get(fullAction);
        } else {
            handlerMethod = this.doResolveHandler(route, fullAction);
            this.cachedHandlers.put(fullAction, handlerMethod);
        }
        return handlerMethod;
    }

    private HandlerMethod doResolveHandler(Router.Route route, String fullAction) throws ActionNotFoundException {
        String controller = fullAction.substring(0, fullAction.lastIndexOf(".")).toLowerCase();
        String action = fullAction.substring(fullAction.lastIndexOf(".") + 1);
        Object controllerObject = this.cachedControllers.get(controller);
        if (controllerObject == null) {
            throw new ActionNotFoundException(fullAction, new Exception("Controller " + controller + " not found"));
        }
        Method actionMethod = this.findActionMethod(action, controllerObject);
        if (actionMethod == null) {
            throw new ActionNotFoundException(fullAction, new Exception("No method public static void " + action + "() was found in class " + controller));
        }
        return new RouterHandler(controllerObject, actionMethod, route);
    }

    private Method findActionMethod(String name, Object controller) {
        Class clazz = AopUtils.getTargetClass((Object)controller);
        while (!clazz.getName().equals("java.lang.Object")) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(name) || !Modifier.isPublic(m.getModifiers())) continue;
                return BridgeMethodResolver.findBridgedMethod((Method)m);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

