/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.resthub.web.springmvc.router.HTTPRequestAdapter;
import org.resthub.web.springmvc.router.Router;
import org.resthub.web.springmvc.router.exceptions.NoRouteFoundException;
import org.resthub.web.springmvc.router.exceptions.RouteFileParsingException;
import org.resthub.web.springmvc.router.support.RouterHandlerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;

public class RouterHandlerMapping
extends AbstractHandlerMapping {
    private static final Logger logger = LoggerFactory.getLogger(RouterHandlerMapping.class);
    private List<String> routeFiles;
    private String servletPrefix;
    private RouterHandlerResolver methodResolver = new RouterHandlerResolver();

    public String getServletPrefix() {
        return this.servletPrefix;
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = servletPrefix;
    }

    public List<String> getRouteFiles() {
        return this.routeFiles;
    }

    public void setRouteFiles(List<String> routeFiles) {
        this.routeFiles = routeFiles;
    }

    public void reloadRoutesConfiguration() {
        ArrayList<Resource> fileResources = new ArrayList<Resource>();
        for (String fileName : this.routeFiles) {
            fileResources.add(this.getApplicationContext().getResource(fileName));
        }
        try {
            Router.detectChanges(fileResources, this.servletPrefix);
        }
        catch (IOException ex) {
            throw new RouteFileParsingException("Could not read route configuration files", ex);
        }
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.methodResolver.setCachedControllers(this.getApplicationContext().getBeansWithAnnotation(Controller.class));
        ArrayList<Resource> fileResources = new ArrayList<Resource>();
        try {
            for (String fileName : this.routeFiles) {
                fileResources.addAll(Arrays.asList(this.getApplicationContext().getResources(fileName)));
            }
            Router.load(fileResources, this.servletPrefix);
        }
        catch (IOException e) {
            throw new RouteFileParsingException("Could not read route configuration files", e);
        }
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        HandlerMethod handler;
        try {
            HTTPRequestAdapter rq = HTTPRequestAdapter.parseRequest(request);
            Router.Route route = Router.route(rq);
            handler = this.methodResolver.resolveHandler(route, rq.action, rq);
            request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, rq.routeArgs);
        }
        catch (NoRouteFoundException nrfe) {
            handler = null;
            logger.trace("no route found for method[" + nrfe.method + "] and path[" + nrfe.path + "]");
        }
        return handler;
    }
}

