/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.resthub.web.springmvc.router.HTTPRequestAdapter;
import org.resthub.web.springmvc.router.Router;
import org.resthub.web.springmvc.router.RouterHandler;
import org.resthub.web.springmvc.router.RouterHandlerAdapter;
import org.resthub.web.springmvc.router.exceptions.NoRouteFoundException;
import org.resthub.web.springmvc.router.exceptions.RouteFileParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;

public class RouterHandlerMapping
extends AbstractHandlerMapping {
    private static final Logger logger = LoggerFactory.getLogger(RouterHandlerAdapter.class);
    private String routeFile;
    private String servletPrefix;

    public String getServletPrefix() {
        return this.servletPrefix;
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = servletPrefix;
    }

    public String getRouteFile() {
        return this.routeFile;
    }

    public void setRouteFile(String routeFile) {
        this.routeFile = routeFile;
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        RouterHandler handler;
        try {
            HTTPRequestAdapter rq = HTTPRequestAdapter.parseRequest(request);
            Router.Route route = Router.route(rq);
            rq.resolveFormat();
            handler = new RouterHandler();
            handler.setRequest(rq);
            handler.setRoute(route);
        }
        catch (NoRouteFoundException nrfe) {
            handler = null;
            logger.trace("no route found for method[" + nrfe.method + "] and path[" + nrfe.path + "]");
        }
        return handler;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        try {
            Resource resource = this.getApplicationContext().getResource(this.routeFile);
            Router.load(resource, this.servletPrefix);
        }
        catch (IOException e) {
            throw new RouteFileParsingException("Cannot parse route file routes.conf", e);
        }
    }
}

