/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web.springmvc.router;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javassist.CtClass;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.resthub.web.springmvc.router.HTTPRequestAdapter;
import org.resthub.web.springmvc.router.Router;
import org.resthub.web.springmvc.router.RouterHandler;
import org.resthub.web.springmvc.router.exceptions.ActionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.support.BindingAwareModelMap;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.support.HandlerMethodInvoker;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class RouterHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter,
Ordered {
    private int order = Integer.MAX_VALUE;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private WebArgumentResolver[] customArgumentResolvers;
    private ModelAndViewResolver[] customModelAndViewResolvers;
    private HttpMessageConverter<?>[] messageConverters;
    private ConfigurableBeanFactory beanFactory;
    private BeanExpressionContext expressionContext;
    private Map<String, Object> cachedControllers;
    private final Logger logger = LoggerFactory.getLogger(RouterHandlerAdapter.class);

    public RouterHandlerAdapter() {
        super(false);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.messageConverters = new HttpMessageConverter[]{new ByteArrayHttpMessageConverter(), stringHttpMessageConverter, new SourceHttpMessageConverter(), new XmlAwareFormHttpMessageConverter()};
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setCustomModelAndViewResolvers(ModelAndViewResolver[] customModelAndViewResolvers) {
        this.customModelAndViewResolvers = customModelAndViewResolvers;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public HttpMessageConverter<?>[] getMessageConverters() {
        return this.messageConverters;
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object target, String objectName) throws Exception {
        return new ServletRequestDataBinder(target, objectName);
    }

    protected HttpInputMessage createHttpInputMessage(HttpServletRequest servletRequest) throws Exception {
        return new ServletServerHttpRequest(servletRequest);
    }

    protected HttpOutputMessage createHttpOutputMessage(HttpServletResponse servletResponse) throws Exception {
        return new ServletServerHttpResponse(servletResponse);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
            this.expressionContext = new BeanExpressionContext(this.beanFactory, (Scope)new RequestScope());
        }
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.cachedControllers = this.getApplicationContext().getBeansWithAnnotation(Controller.class);
    }

    public boolean supports(Object handler) {
        return handler instanceof RouterHandler;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RouterHandler routerHandler = (RouterHandler)handler;
        HTTPRequestAdapter req = routerHandler.getRequest();
        Router.Route route = routerHandler.getRoute();
        Method actionMethod = null;
        RouterMethodResolver methodResolver = new RouterMethodResolver();
        Object[] ca = methodResolver.resolveActionMethod(this.cachedControllers, req.action);
        actionMethod = (Method)ca[1];
        req.controller = ca[0].getClass().getName();
        req.controllerClass = ca[0].getClass();
        req.actionMethod = actionMethod.getName();
        req.action = req.controller + "." + req.actionMethod;
        req.invokedMethod = actionMethod;
        this.logger.trace("------- " + actionMethod);
        request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, req.routeArgs);
        ModelAndView mav = null;
        RouterhandlerMethodInvoker methodInvoker = new RouterhandlerMethodInvoker(methodResolver);
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        BindingAwareModelMap implicitModel = new BindingAwareModelMap();
        Object result = methodInvoker.invokeHandlerMethod(actionMethod, ca[0], (NativeWebRequest)webRequest, (ExtendedModelMap)implicitModel);
        mav = methodInvoker.getModelAndView(actionMethod, req.controllerClass, result, (ExtendedModelMap)implicitModel, webRequest);
        methodInvoker.updateModelAttributes(handler, mav != null ? mav.getModel() : null, (ExtendedModelMap)implicitModel, (NativeWebRequest)webRequest);
        return mav;
    }

    protected void addReturnValueAsModelAttribute(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel) {
        String attrName;
        ModelAttribute attr = (ModelAttribute)AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class);
        String string = attrName = attr != null ? attr.value() : "";
        if ("".equals(attrName)) {
            Class resolvedType = GenericTypeResolver.resolveReturnType((Method)handlerMethod, (Class)handlerType);
            attrName = Conventions.getVariableNameForReturnType((Method)handlerMethod, (Class)resolvedType, (Object)returnValue);
        }
        implicitModel.addAttribute(attrName, returnValue);
    }

    private class RouterhandlerMethodInvoker
    extends HandlerMethodInvoker {
        private boolean responseArgumentUsed;

        private RouterhandlerMethodInvoker(HandlerMethodResolver resolver) {
            super(resolver, RouterHandlerAdapter.this.webBindingInitializer, RouterHandlerAdapter.this.sessionAttributeStore, RouterHandlerAdapter.this.parameterNameDiscoverer, RouterHandlerAdapter.this.customArgumentResolvers, RouterHandlerAdapter.this.messageConverters);
            this.responseArgumentUsed = false;
        }

        protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
            throw new MissingServletRequestParameterException(paramName, paramType.getSimpleName());
        }

        protected void raiseSessionRequiredException(String message) throws Exception {
            throw new HttpSessionRequiredException(message);
        }

        protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return RouterHandlerAdapter.this.createBinder((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class), target, objectName);
        }

        protected void doBind(WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
            ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
            servletBinder.bind((ServletRequest)webRequest.getNativeRequest(ServletRequest.class));
        }

        protected HttpInputMessage createHttpInputMessage(NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            return RouterHandlerAdapter.this.createHttpInputMessage(servletRequest);
        }

        protected HttpOutputMessage createHttpOutputMessage(NativeWebRequest webRequest) throws Exception {
            HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse();
            return RouterHandlerAdapter.this.createHttpOutputMessage(servletResponse);
        }

        protected Object resolveDefaultValue(String value) {
            if (RouterHandlerAdapter.this.beanFactory == null) {
                return value;
            }
            String placeholdersResolved = RouterHandlerAdapter.this.beanFactory.resolveEmbeddedValue(value);
            BeanExpressionResolver exprResolver = RouterHandlerAdapter.this.beanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return value;
            }
            return exprResolver.evaluate(placeholdersResolved, RouterHandlerAdapter.this.expressionContext);
        }

        protected Object resolveCookieValue(String cookieName, Class paramType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Cookie cookieValue = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)cookieName);
            if (Cookie.class.isAssignableFrom(paramType)) {
                return cookieValue;
            }
            if (cookieValue != null) {
                return RouterHandlerAdapter.this.urlPathHelper.decodeRequestString(servletRequest, cookieValue.getValue());
            }
            return null;
        }

        protected String resolvePathVariable(String pathVarName, Class paramType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Map uriTemplateVariables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (uriTemplateVariables == null || !uriTemplateVariables.containsKey(pathVarName)) {
                throw new IllegalStateException("Could not find @PathVariable [" + pathVarName + "] in @RequestMapping");
            }
            return (String)uriTemplateVariables.get(pathVarName);
        }

        protected Object resolveStandardArgument(Class<?> parameterType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            if (ServletRequest.class.isAssignableFrom(parameterType) || MultipartRequest.class.isAssignableFrom(parameterType)) {
                Object nativeRequest = webRequest.getNativeRequest(parameterType);
                if (nativeRequest == null) {
                    throw new IllegalStateException("Current request is not of type [" + parameterType.getName() + "]: " + request);
                }
                return nativeRequest;
            }
            if (ServletResponse.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                Object nativeResponse = webRequest.getNativeResponse(parameterType);
                if (nativeResponse == null) {
                    throw new IllegalStateException("Current response is not of type [" + parameterType.getName() + "]: " + response);
                }
                return nativeResponse;
            }
            if (HttpSession.class.isAssignableFrom(parameterType)) {
                return request.getSession();
            }
            if (Principal.class.isAssignableFrom(parameterType)) {
                return request.getUserPrincipal();
            }
            if (Locale.class.equals(parameterType)) {
                return RequestContextUtils.getLocale((HttpServletRequest)request);
            }
            if (InputStream.class.isAssignableFrom(parameterType)) {
                return request.getInputStream();
            }
            if (Reader.class.isAssignableFrom(parameterType)) {
                return request.getReader();
            }
            if (OutputStream.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getOutputStream();
            }
            if (Writer.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getWriter();
            }
            return super.resolveStandardArgument(parameterType, webRequest);
        }

        public ModelAndView getModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel, ServletWebRequest webRequest) throws Exception {
            ResponseStatus responseStatusAnn = (ResponseStatus)AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseStatus.class);
            if (responseStatusAnn != null) {
                HttpStatus responseStatus = responseStatusAnn.value();
                String reason = responseStatusAnn.reason();
                if (!StringUtils.hasText((String)reason)) {
                    webRequest.getResponse().setStatus(responseStatus.value());
                } else {
                    webRequest.getResponse().sendError(responseStatus.value(), reason);
                }
                webRequest.getRequest().setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)responseStatus);
                this.responseArgumentUsed = true;
            }
            if (RouterHandlerAdapter.this.customModelAndViewResolvers != null) {
                for (ModelAndViewResolver mavResolver : RouterHandlerAdapter.this.customModelAndViewResolvers) {
                    ModelAndView mav = mavResolver.resolveModelAndView(handlerMethod, handlerType, returnValue, implicitModel, (NativeWebRequest)webRequest);
                    if (mav == ModelAndViewResolver.UNRESOLVED) continue;
                    return mav;
                }
            }
            if (returnValue instanceof HttpEntity) {
                this.handleHttpEntityResponse((HttpEntity)returnValue, webRequest);
                return null;
            }
            if (AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseBody.class) != null) {
                this.handleResponseBody(returnValue, webRequest);
                return null;
            }
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Model) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects(((Model)returnValue).asMap());
            }
            if (returnValue instanceof View) {
                return new ModelAndView((View)returnValue).addAllObjects((Map)implicitModel);
            }
            if (AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class) != null) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map)implicitModel);
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue == null) {
                if (this.responseArgumentUsed || webRequest.isNotModified()) {
                    return null;
                }
                return new ModelAndView().addAllObjects((Map)implicitModel);
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map)implicitModel);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }

        private void handleResponseBody(Object returnValue, ServletWebRequest webRequest) throws Exception {
            if (returnValue == null) {
                return;
            }
            HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
            this.writeWithMessageConverters(returnValue, inputMessage, outputMessage);
        }

        private void handleHttpEntityResponse(HttpEntity<?> responseEntity, ServletWebRequest webRequest) throws Exception {
            Object body;
            HttpHeaders entityHeaders;
            if (responseEntity == null) {
                return;
            }
            HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
            if (responseEntity instanceof ResponseEntity && outputMessage instanceof ServerHttpResponse) {
                ((ServerHttpResponse)outputMessage).setStatusCode(((ResponseEntity)responseEntity).getStatusCode());
            }
            if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
                outputMessage.getHeaders().putAll((Map)entityHeaders);
            }
            if ((body = responseEntity.getBody()) != null) {
                this.writeWithMessageConverters(body, inputMessage, outputMessage);
            } else {
                outputMessage.getBody();
            }
        }

        private void writeWithMessageConverters(Object returnValue, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
            List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            }
            MediaType.sortByQualityValue((List)acceptedMediaTypes);
            Class<?> returnValueType = returnValue.getClass();
            ArrayList allSupportedMediaTypes = new ArrayList();
            if (RouterHandlerAdapter.this.getMessageConverters() != null) {
                for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    for (HttpMessageConverter<?> messageConverter : RouterHandlerAdapter.this.getMessageConverters()) {
                        if (!messageConverter.canWrite(returnValueType, acceptedMediaType)) continue;
                        messageConverter.write(returnValue, acceptedMediaType, outputMessage);
                        if (RouterHandlerAdapter.this.logger.isDebugEnabled()) {
                            MediaType contentType = outputMessage.getHeaders().getContentType();
                            if (contentType == null) {
                                contentType = acceptedMediaType;
                            }
                            RouterHandlerAdapter.this.logger.debug("Written [" + returnValue + "] as \"" + contentType + "\" using [" + messageConverter + "]");
                        }
                        this.responseArgumentUsed = true;
                        return;
                    }
                }
                for (HttpMessageConverter messageConverter : RouterHandlerAdapter.this.messageConverters) {
                    allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
                }
            }
            throw new HttpMediaTypeNotAcceptableException(allSupportedMediaTypes);
        }
    }

    public static class LocalVariablesNamesTracer {
        public static Integer computeMethodHash(CtClass[] parameters) {
            String[] names = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                names[i] = parameters[i].getName();
            }
            return LocalVariablesNamesTracer.computeMethodHash(names);
        }

        public static Integer computeMethodHash(Class[] parameters) {
            String[] names = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> param = parameters[i];
                names[i] = "";
                if (param.isArray()) {
                    int level = 1;
                    param = param.getComponentType();
                    while (param.isArray()) {
                        ++level;
                        param = param.getComponentType();
                    }
                    names[i] = param.getName();
                    for (int j = 0; j < level; ++j) {
                        int n = i;
                        names[n] = names[n] + "[]";
                    }
                    continue;
                }
                names[i] = param.getName();
            }
            return LocalVariablesNamesTracer.computeMethodHash(names);
        }

        public static Integer computeMethodHash(String[] parameters) {
            StringBuffer buffer = new StringBuffer();
            for (String param : parameters) {
                buffer.append(param);
            }
            Integer hash = buffer.toString().hashCode();
            if (hash < 0) {
                return -hash.intValue();
            }
            return hash;
        }
    }

    public class RouterMethodResolver
    extends HandlerMethodResolver {
        private Object[] resolveActionMethod(Map<String, Object> controllers, String fullAction) throws ActionNotFoundException {
            Method actionMethod = null;
            Object controllerObject = null;
            String controller = fullAction.substring(0, fullAction.lastIndexOf("."));
            String action = fullAction.substring(fullAction.lastIndexOf(".") + 1);
            controllerObject = controllers.get(controller);
            if (controllerObject == null) {
                throw new ActionNotFoundException(fullAction, new Exception("Controller " + controller + " not found"));
            }
            actionMethod = this.findActionMethod(action, controllerObject);
            if (actionMethod == null) {
                throw new ActionNotFoundException(fullAction, new Exception("No method public static void " + action + "() was found in class " + controller));
            }
            return new Object[]{controllerObject, actionMethod};
        }

        public Method findActionMethod(String name, Object controller) {
            Class clazz = AopUtils.getTargetClass((Object)controller);
            while (!clazz.getName().equals("java.lang.Object")) {
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!m.getName().equalsIgnoreCase(name) || !Modifier.isPublic(m.getModifiers())) continue;
                    return BridgeMethodResolver.findBridgedMethod((Method)m);
                }
                clazz = clazz.getSuperclass();
            }
            return null;
        }
    }
}

