/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.resthub.web.PageResponse;
import org.resthub.web.exception.SerializationException;
import org.springframework.data.domain.Page;

public class XmlHelper {
    protected static ObjectMapper objectMapper;

    protected static void initialize() {
        JacksonXmlModule xmlModule = new JacksonXmlModule();
        xmlModule.setDefaultUseWrapper(false);
        objectMapper = new XmlMapper(xmlModule);
        SimpleModule module = new SimpleModule();
        module.addAbstractTypeMapping(Page.class, PageResponse.class);
        objectMapper.registerModule((Module)module);
        JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
    }

    public ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            XmlHelper.initialize();
        }
        return objectMapper;
    }

    public static String serialize(Object o) {
        if (objectMapper == null) {
            XmlHelper.initialize();
        }
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        try {
            objectMapper.writeValue((OutputStream)baOutputStream, o);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
        return ((Object)baOutputStream).toString();
    }

    public static String serialize(Object o, Class<?> view) {
        if (objectMapper == null) {
            XmlHelper.initialize();
        }
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        try {
            ObjectWriter writter = objectMapper.writerWithView(view);
            writter.writeValue((OutputStream)baOutputStream, o);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
        return ((Object)baOutputStream).toString();
    }

    public static <T> T deserialize(String content, Class<T> type) {
        if (objectMapper == null) {
            XmlHelper.initialize();
        }
        try {
            return (T)objectMapper.readValue(content, type);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    public static <T> T deserialize(String content, TypeReference valueTypeRef) {
        if (objectMapper == null) {
            XmlHelper.initialize();
        }
        try {
            return (T)objectMapper.readValue(content, valueTypeRef);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }
}

