/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

class ContentType {
    private final ContentType parent;
    static final ContentType MIXED_ELEMENT_CLASS = new ContentType();
    static final ContentType NOT_ALLOWED = new ContentType();
    static final ContentType SIMPLE_TYPE = new ContentType();
    static final ContentType SIMPLE_TYPE_CHOICE = new ContentType(SIMPLE_TYPE);
    static final ContentType VALUE = new ContentType(SIMPLE_TYPE);
    static final ContentType EMPTY = new ContentType();
    static final ContentType TEXT = new ContentType(MIXED_ELEMENT_CLASS);
    static final ContentType MIXED_MODEL = new ContentType();
    static final ContentType INTERLEAVE_MIXED_MODEL = new ContentType(MIXED_MODEL);
    static final ContentType MODEL_GROUP = new ContentType();
    static final ContentType ELEMENT_CLASS = new ContentType(MODEL_GROUP);
    static final ContentType DIRECT_SINGLE_ELEMENT = new ContentType(ELEMENT_CLASS);
    static final ContentType ZERO_OR_MORE_ELEMENT_CLASS = new ContentType(MODEL_GROUP);
    static final ContentType INTERLEAVE_ZERO_OR_MORE_ELEMENT_CLASS = new ContentType(ZERO_OR_MORE_ELEMENT_CLASS);
    static final ContentType ENUM = new ContentType(SIMPLE_TYPE);
    static final ContentType ERROR = new ContentType();

    private ContentType() {
        this.parent = null;
    }

    private ContentType(ContentType contentType) {
        this.parent = contentType;
    }

    boolean isA(ContentType contentType) {
        if (this == contentType) {
            return true;
        }
        return this.parent != null && this.parent.isA(contentType);
    }

    static ContentType zeroOrMore(ContentType contentType) {
        if (contentType.isA(ELEMENT_CLASS)) {
            return ZERO_OR_MORE_ELEMENT_CLASS;
        }
        if (contentType.isA(MIXED_ELEMENT_CLASS)) {
            return MIXED_MODEL;
        }
        return ContentType.oneOrMore(contentType);
    }

    static ContentType oneOrMore(ContentType contentType) {
        if (contentType == ERROR) {
            return ERROR;
        }
        if (contentType == EMPTY) {
            return EMPTY;
        }
        if (contentType.isA(MIXED_ELEMENT_CLASS)) {
            return MIXED_MODEL;
        }
        if (contentType.isA(MODEL_GROUP)) {
            return MODEL_GROUP;
        }
        return null;
    }

    static ContentType group(ContentType contentType, ContentType contentType2) {
        if (contentType.isA(MODEL_GROUP) && contentType2.isA(MODEL_GROUP)) {
            return MODEL_GROUP;
        }
        return ContentType.groupOrInterleave(contentType, contentType2);
    }

    static ContentType mixed(ContentType contentType) {
        if (contentType.isA(EMPTY)) {
            return TEXT;
        }
        if (contentType.isA(ZERO_OR_MORE_ELEMENT_CLASS)) {
            return MIXED_MODEL;
        }
        return null;
    }

    static ContentType interleave(ContentType contentType, ContentType contentType2) {
        if (contentType.isA(ZERO_OR_MORE_ELEMENT_CLASS) && contentType2.isA(ZERO_OR_MORE_ELEMENT_CLASS)) {
            return INTERLEAVE_ZERO_OR_MORE_ELEMENT_CLASS;
        }
        if ((contentType.isA(MIXED_MODEL) || contentType == TEXT) && contentType2.isA(ZERO_OR_MORE_ELEMENT_CLASS) || contentType.isA(ZERO_OR_MORE_ELEMENT_CLASS) && (contentType2.isA(MIXED_MODEL) || contentType2 == TEXT)) {
            return INTERLEAVE_MIXED_MODEL;
        }
        return ContentType.groupOrInterleave(contentType, contentType2);
    }

    private static ContentType groupOrInterleave(ContentType contentType, ContentType contentType2) {
        if (contentType == ERROR || contentType2 == ERROR) {
            return ERROR;
        }
        if (contentType.isA(EMPTY)) {
            return ContentType.ref(contentType2);
        }
        if (contentType2.isA(EMPTY)) {
            return ContentType.ref(contentType);
        }
        return null;
    }

    static ContentType optional(ContentType contentType) {
        if (contentType == ERROR) {
            return ERROR;
        }
        if (contentType == EMPTY) {
            return EMPTY;
        }
        if (contentType.isA(MODEL_GROUP)) {
            return MODEL_GROUP;
        }
        if (contentType.isA(MIXED_ELEMENT_CLASS)) {
            return MIXED_ELEMENT_CLASS;
        }
        if (contentType == NOT_ALLOWED) {
            return MODEL_GROUP;
        }
        return null;
    }

    static ContentType choice(ContentType contentType, ContentType contentType2) {
        if (contentType == ERROR || contentType2 == ERROR) {
            return ERROR;
        }
        if (contentType == EMPTY && contentType2 == EMPTY) {
            return EMPTY;
        }
        if (contentType == NOT_ALLOWED) {
            if (contentType2 == NOT_ALLOWED) {
                return NOT_ALLOWED;
            }
            if (contentType2.isA(ELEMENT_CLASS)) {
                return ELEMENT_CLASS;
            }
            if (contentType2.isA(MIXED_ELEMENT_CLASS)) {
                return MIXED_ELEMENT_CLASS;
            }
            if (contentType2.isA(MODEL_GROUP)) {
                return MODEL_GROUP;
            }
            if (contentType2.isA(ENUM)) {
                return ENUM;
            }
            return null;
        }
        if (contentType2 == NOT_ALLOWED) {
            return ContentType.choice(contentType2, contentType);
        }
        if (contentType.isA(ENUM) && contentType2.isA(ENUM)) {
            return ENUM;
        }
        if (contentType.isA(SIMPLE_TYPE) && contentType2.isA(SIMPLE_TYPE)) {
            return SIMPLE_TYPE_CHOICE;
        }
        if (contentType.isA(ELEMENT_CLASS) && contentType2.isA(ELEMENT_CLASS)) {
            return ELEMENT_CLASS;
        }
        if (contentType.isA(MODEL_GROUP) && contentType2.isA(MODEL_GROUP)) {
            return MODEL_GROUP;
        }
        if (contentType.isA(MIXED_ELEMENT_CLASS) && contentType2.isA(ELEMENT_CLASS) || contentType.isA(ELEMENT_CLASS) && contentType2.isA(MIXED_ELEMENT_CLASS)) {
            return MIXED_ELEMENT_CLASS;
        }
        return null;
    }

    static ContentType ref(ContentType contentType) {
        if (contentType.isA(DIRECT_SINGLE_ELEMENT)) {
            return ELEMENT_CLASS;
        }
        return contentType;
    }
}

