/*
 * Decompiled with CFR 0.152.
 */
package org.rekex.regexp;

import java.util.function.Function;
import org.rekex.common_util.SwitchOnType;
import org.rekex.regexp.PkgUtil;
import org.rekex.regexp.RegExp;
import org.rekex.regexp.ToRegex;

class ToTreeText {
    StringBuilder sb = new StringBuilder();
    static final String TAB = " ".repeat(4);
    static final String EOL = System.lineSeparator();
    final Function<RegExp, Function<String, Object>> toTree = new SwitchOnType().on(RegExp.CharClass.Single.class, r -> s -> this.onSingle((RegExp.CharClass.Single)r, (String)s)).on(RegExp.CharClass.Range.class, r -> s -> this.onRange((RegExp.CharClass.Range)r, (String)s)).on(RegExp.CharClass.Union.class, r -> s -> this.onUnion((RegExp.CharClass.Union)r, (String)s)).on(RegExp.CharClass.Intersection.class, r -> s -> this.onIntersection((RegExp.CharClass.Intersection)r, (String)s)).on(RegExp.CharClass.Negation.class, r -> s -> this.onNegation((RegExp.CharClass.Negation)r, (String)s)).on(RegExp.CharClass.Predefined.class, r -> s -> this.onPredefined((RegExp.CharClass.Predefined)r, (String)s)).on(RegExp.Alternation.class, r -> s -> this.onAlternation((RegExp.Alternation)r, (String)s)).on(RegExp.Concatenation.class, r -> s -> this.onConcatenation((RegExp.Concatenation)r, (String)s)).on(RegExp.Quantified.class, r -> s -> this.onQuantified((RegExp.Quantified)r, (String)s)).on(RegExp.Boundary.class, r -> s -> this.onBoundary((RegExp.Boundary)r, (String)s)).on(RegExp.Lookaround.class, r -> s -> this.onLookaround((RegExp.Lookaround)r, (String)s)).on(RegExp.BackReference.WithNumber.class, r -> s -> this.onBackReferenceWithNumber((RegExp.BackReference.WithNumber)r, (String)s)).on(RegExp.BackReference.WithName.class, r -> s -> this.onBackReferenceWithName((RegExp.BackReference.WithName)r, (String)s)).on(RegExp.Group.Unnamed.class, r -> s -> this.onGroupUnnamed((RegExp.Group.Unnamed)r, (String)s)).on(RegExp.Group.Named.class, r -> s -> this.onGroupNamed((RegExp.Group.Named)r, (String)s)).on(RegExp.AtomicGroup.class, r -> s -> this.onAtomicGroup((RegExp.AtomicGroup)r, (String)s)).on(RegExp.Flagged.class, r -> s -> this.onFlagged((RegExp.Flagged)r, (String)s)).on(RegExp.Opaque.class, r -> s -> this.onOpaque((RegExp.Opaque)r, (String)s)).complete(RegExp.class);

    ToTreeText() {
    }

    public static String toTreeText(RegExp exp) {
        ToTreeText thiz = new ToTreeText();
        thiz.print2(exp, "", EOL);
        return thiz.sb.toString();
    }

    Object print2(RegExp exp, String indent1, String indent2) {
        this.sb.append(indent1);
        return this.toTree.apply(exp).apply(indent2);
    }

    Object print1(RegExp exp, String indent) {
        return this.print2(exp, indent, indent);
    }

    Object print3(RegExp[] args, String indent1, String indent2, String indent2L) {
        for (int i = 0; i < args.length; ++i) {
            RegExp arg = args[i];
            if (arg instanceof RegExp.CharClass.Single) {
                RegExp.CharClass.Single single = (RegExp.CharClass.Single)arg;
                if (i > 0 && args[i - 1] instanceof RegExp.CharClass.Single) {
                    this.appendSingle(single);
                    continue;
                }
            } else if (arg instanceof RegExp.CharClass.Range) {
                RegExp.CharClass.Range r = (RegExp.CharClass.Range)arg;
                if (i > 0 && args[i - 1] instanceof RegExp.CharClass.Range) {
                    this.appendRange(r);
                    continue;
                }
            }
            boolean last = i == args.length - 1;
            this.print2(arg, indent1, last ? indent2L : indent2);
        }
        return this.sb;
    }

    Object onSingle(RegExp.CharClass.Single single, String indent2) {
        this.sb.append("chars ");
        return this.appendSingle(single);
    }

    Object appendSingle(RegExp.CharClass.Single single) {
        return this.sb.append(ToTreeText.esc2(single.ch()));
    }

    Object onRange(RegExp.CharClass.Range r, String indent2) {
        this.sb.append("range ");
        return this.appendRange(r);
    }

    Object appendRange(RegExp.CharClass.Range r) {
        return this.sb.append("[").append(ToTreeText.esc2(r.from())).append("-").append(ToTreeText.esc2(r.to())).append("]");
    }

    Object onUnion(RegExp.CharClass.Union union, String indent2) {
        this.sb.append("union");
        return this.print3(union.args(), indent2 + " :--", indent2 + " :  ", indent2 + TAB);
    }

    Object onIntersection(RegExp.CharClass.Intersection intersect, String indent2) {
        this.sb.append("intersect");
        return this.print3(intersect.args(), indent2 + " && ", indent2 + " .  ", indent2 + TAB);
    }

    Object onNegation(RegExp.CharClass.Negation neg, String indent2) {
        this.sb.append("negate");
        return this.print1(neg.arg(), indent2 + TAB);
    }

    Object onPredefined(RegExp.CharClass.Predefined pd, String indent2) {
        this.sb.append("predefined: ");
        return this.appendRegex(pd);
    }

    Object onAlternation(RegExp.Alternation alt, String indent2) {
        this.sb.append("alt");
        return this.print3(alt.args(), indent2 + " :--", indent2 + " :  ", indent2 + TAB);
    }

    Object onConcatenation(RegExp.Concatenation seq, String indent2) {
        if (seq.args().length == 0) {
            return this.sb.append("epsilon");
        }
        this.sb.append("seq");
        return this.print3(seq.args(), indent2 + " |--", indent2 + " |  ", indent2 + TAB);
    }

    Object onQuantified(RegExp.Quantified q, String indent2) {
        this.sb.append(ToTreeText.quantDesc(q));
        return this.print1(q.arg(), indent2 + TAB);
    }

    Object onBoundary(RegExp.Boundary r, String indent2) {
        this.sb.append("boundary: ");
        return this.appendRegex(r);
    }

    Object onLookaround(RegExp.Lookaround look, String indent2) {
        this.sb.append("look_").append(look.ahead() ? "ahead " : "behind ").append(look.positive() ? "positive" : "negative").append(ToRegex.beginningOf(look));
        return this.print1(look.arg(), indent2 + TAB);
    }

    Object onBackReferenceWithNumber(RegExp.BackReference.WithNumber r, String indent2) {
        this.sb.append("back_ref: ");
        return this.appendRegex(r);
    }

    Object onBackReferenceWithName(RegExp.BackReference.WithName r, String indent2) {
        this.sb.append("back_ref: ");
        return this.appendRegex(r);
    }

    Object onGroupUnnamed(RegExp.Group.Unnamed group, String indent2) {
        this.sb.append("group(");
        return this.print1(group.arg(), indent2 + TAB);
    }

    Object onGroupNamed(RegExp.Group.Named group, String indent2) {
        this.sb.append("group(?<").append(group.name()).append(">");
        return this.print1(group.arg(), indent2 + TAB);
    }

    Object onAtomicGroup(RegExp.AtomicGroup group, String indent2) {
        this.sb.append("atomic_group(?>");
        return this.print1(group.arg(), indent2 + TAB);
    }

    Object onFlagged(RegExp.Flagged f, String indent2) {
        this.sb.append("flag(?").append(ToRegex.flagsStr(f)).append(":");
        return this.print1(f.arg(), indent2 + TAB);
    }

    Object onOpaque(RegExp.Opaque opaque, String indent2) {
        this.sb.append("opaque: ");
        return this.appendRegex(opaque);
    }

    Object appendRegex(RegExp exp) {
        return this.sb.append(ToRegex.regex(exp));
    }

    static String esc2(int ch) {
        if (32 == ch) {
            return "\\x20";
        }
        if (33 <= ch && ch <= 126) {
            return "" + ch;
        }
        return PkgUtil.esc(ch);
    }

    static String quantDesc(RegExp.Quantified q) {
        long INFINITY = Long.MAX_VALUE;
        long _min = q.min();
        long _max = q.max();
        char _greediness = q.greediness();
        Object greed = "";
        if (_greediness != '\u0000') {
            greed = (String)greed + _greediness;
            greed = (String)greed + (_greediness == '?' ? " reluctant" : " possessive");
        }
        if (_min == 0L && _max == 1L) {
            return "opt?" + (String)greed;
        }
        if (_min == 0L && _max == INFINITY) {
            return "rep0*" + (String)greed;
        }
        if (_min == 1L && _max == INFINITY) {
            return "rep1+" + (String)greed;
        }
        if (_min == _max) {
            return "times{" + _min + "}" + (String)greed;
        }
        if (_max == INFINITY) {
            return "times{" + _min + ",}" + (String)greed;
        }
        return "times{" + _min + "," + _max + "}" + (String)greed;
    }
}

