/*
 * Decompiled with CFR 0.152.
 */
package org.rekex.regexp;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.rekex.common_util.SwitchOnType;
import org.rekex.regexp.RegExp;

record ToSimplify() {
    static final Function<RegExp, RegExp> simplify = new SwitchOnType().on(RegExp.CharClass.Single.class, ToSimplify::onSingle).on(RegExp.CharClass.Range.class, ToSimplify::onRange).on(RegExp.CharClass.Union.class, ToSimplify::onUnion).on(RegExp.CharClass.Intersection.class, ToSimplify::onIntersection).on(RegExp.CharClass.Negation.class, ToSimplify::onNegation).on(RegExp.CharClass.Predefined.class, ToSimplify::onPredefined).on(RegExp.Alternation.class, ToSimplify::onAlternation).on(RegExp.Concatenation.class, ToSimplify::onConcatenation).on(RegExp.Quantified.class, ToSimplify::onQuantified).on(RegExp.Boundary.class, ToSimplify::onBoundary).on(RegExp.Lookaround.class, ToSimplify::onLookaround).on(RegExp.BackReference.WithNumber.class, ToSimplify::onBackReferenceWithNumber).on(RegExp.BackReference.WithName.class, ToSimplify::onBackReferenceWithName).on(RegExp.Group.Unnamed.class, ToSimplify::onGroupUnnamed).on(RegExp.Group.Named.class, ToSimplify::onGroupNamed).on(RegExp.AtomicGroup.class, ToSimplify::onAtomicGroup).on(RegExp.Flagged.class, ToSimplify::onFlagged).on(RegExp.Opaque.class, ToSimplify::onOpaque).complete(RegExp.class);

    public static RegExp simplify(RegExp exp) {
        return simplify.apply(exp);
    }

    static RegExp.CharClass.Single onSingle(RegExp.CharClass.Single r) {
        return r;
    }

    static RegExp.CharClass.Range onRange(RegExp.CharClass.Range r) {
        return r;
    }

    static RegExp.CharClass onUnion(RegExp.CharClass.Union r) {
        RegExp.CharClass[] args = (RegExp.CharClass[])ToSimplify.flatten((RegExp[])r.args(), (T a) -> {
            RegExp.CharClass[] charClassArray;
            if (a instanceof RegExp.CharClass.Union) {
                RegExp.CharClass.Union union = (RegExp.CharClass.Union)a;
                charClassArray = union.args();
            } else {
                charClassArray = null;
            }
            return charClassArray;
        });
        if (args.length == 1) {
            return args[0];
        }
        return new RegExp.CharClass.Union(args);
    }

    static RegExp.CharClass onIntersection(RegExp.CharClass.Intersection r) {
        RegExp.CharClass[] args = (RegExp.CharClass[])ToSimplify.flatten((RegExp[])r.args(), (T a) -> {
            RegExp.CharClass[] charClassArray;
            if (a instanceof RegExp.CharClass.Intersection) {
                RegExp.CharClass.Intersection intersect = (RegExp.CharClass.Intersection)a;
                charClassArray = intersect.args();
            } else {
                charClassArray = null;
            }
            return charClassArray;
        });
        if (args.length == 1) {
            return args[0];
        }
        return new RegExp.CharClass.Intersection(args);
    }

    static RegExp.CharClass onNegation(RegExp.CharClass.Negation r) {
        RegExp.CharClass cc = (RegExp.CharClass)ToSimplify.simplify(r.arg());
        if (cc instanceof RegExp.CharClass.Negation) {
            RegExp.CharClass.Negation neg = (RegExp.CharClass.Negation)cc;
            return neg.arg();
        }
        return new RegExp.CharClass.Negation(cc);
    }

    static RegExp.CharClass.Predefined onPredefined(RegExp.CharClass.Predefined r) {
        return r;
    }

    static RegExp onAlternation(RegExp.Alternation r) {
        RegExp[] args = ToSimplify.flatten((RegExp[])r.args(), (T a) -> {
            RegExp[] regExpArray;
            if (a instanceof RegExp.Alternation) {
                RegExp.Alternation alt = (RegExp.Alternation)a;
                regExpArray = alt.args();
            } else {
                regExpArray = null;
            }
            return regExpArray;
        });
        if ((args = ToSimplify.mergeAltCc(args)).length == 1) {
            return args[0];
        }
        return new RegExp.Alternation(args);
    }

    static RegExp onConcatenation(RegExp.Concatenation r) {
        RegExp[] args = ToSimplify.flatten((RegExp[])r.args(), (T a) -> {
            RegExp[] regExpArray;
            if (a instanceof RegExp.Concatenation) {
                RegExp.Concatenation seq = (RegExp.Concatenation)a;
                regExpArray = seq.args();
            } else {
                regExpArray = null;
            }
            return regExpArray;
        });
        if (args.length == 1) {
            return args[0];
        }
        return new RegExp.Concatenation(args);
    }

    static RegExp.Quantified onQuantified(RegExp.Quantified q) {
        boolean greedy = false;
        RegExp exp = ToSimplify.simplify(q.arg());
        if (exp instanceof RegExp.Quantified) {
            RegExp.Quantified q1 = (RegExp.Quantified)exp;
            if (q.greediness() == '\u0000' && q1.greediness() == '\u0000') {
                try {
                    long min2 = Math.multiplyExact(q.min(), q1.min());
                    long INF = Long.MAX_VALUE;
                    long max2 = q.max() == 0L || q1.max() == 0L ? 0L : (q.max() == Long.MAX_VALUE || q1.max() == Long.MAX_VALUE ? Long.MAX_VALUE : Math.multiplyExact(q.max(), q1.max()));
                    return new RegExp.Quantified(q1.arg(), min2, max2, '\u0000');
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
        }
        return new RegExp.Quantified(exp, q.min(), q.max(), q.greediness());
    }

    static RegExp.Boundary onBoundary(RegExp.Boundary r) {
        return r;
    }

    static RegExp.Lookaround onLookaround(RegExp.Lookaround r) {
        RegExp exp = ToSimplify.simplify(r.arg());
        return new RegExp.Lookaround(exp, r.ahead(), r.positive());
    }

    static RegExp.BackReference.WithNumber onBackReferenceWithNumber(RegExp.BackReference.WithNumber r) {
        return r;
    }

    static RegExp.BackReference.WithName onBackReferenceWithName(RegExp.BackReference.WithName r) {
        return r;
    }

    static RegExp.Group.Unnamed onGroupUnnamed(RegExp.Group.Unnamed r) {
        RegExp exp = ToSimplify.simplify(r.arg());
        return new RegExp.Group.Unnamed(exp);
    }

    static RegExp.Group.Named onGroupNamed(RegExp.Group.Named r) {
        RegExp exp = ToSimplify.simplify(r.arg());
        return new RegExp.Group.Named(exp, r.name());
    }

    static RegExp.AtomicGroup onAtomicGroup(RegExp.AtomicGroup r) {
        RegExp exp = ToSimplify.simplify(r.arg());
        return new RegExp.AtomicGroup(exp);
    }

    static RegExp.Flagged onFlagged(RegExp.Flagged r) {
        RegExp exp = ToSimplify.simplify(r.arg());
        return new RegExp.Flagged(exp, r.onFlags(), r.offFlags());
    }

    static RegExp.Opaque onOpaque(RegExp.Opaque r) {
        return r;
    }

    static <E extends RegExp> E[] flatten(E[] arr, Function<E, E[]> mapper) {
        RegExp[] arr1 = (RegExp[])Arrays.copyOf(arr, arr.length);
        for (int i = 0; i < arr.length; ++i) {
            RegExp sim;
            arr1[i] = sim = ToSimplify.simplify(arr[i]);
        }
        arr = arr1;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object e : arr) {
            RegExp[] a2 = (RegExp[])mapper.apply(e);
            if (a2 == null) {
                list.add(e);
                continue;
            }
            Collections.addAll(list, a2);
        }
        RegExp[] arr2 = (RegExp[])Array.newInstance(arr.getClass().getComponentType(), list.size());
        return list.toArray(arr2);
    }

    static RegExp[] mergeAltCc(RegExp[] args) {
        ArrayList<RegExp> list = new ArrayList<RegExp>();
        RegExp.CharClass lastAsCC = null;
        for (RegExp arg : args) {
            if (arg instanceof RegExp.CharClass) {
                RegExp.CharClass.Union union;
                RegExp.CharClass argCC = (RegExp.CharClass)arg;
                if (argCC instanceof RegExp.CharClass.Union && (union = (RegExp.CharClass.Union)argCC).args().length == 0) continue;
                if (lastAsCC == null) {
                    list.add(arg);
                    lastAsCC = argCC;
                    continue;
                }
                lastAsCC = new RegExp.CharClass.Union(lastAsCC, argCC);
                lastAsCC = (RegExp.CharClass)ToSimplify.simplify(lastAsCC);
                list.set(list.size() - 1, lastAsCC);
                continue;
            }
            list.add(arg);
            lastAsCC = null;
        }
        if (list.isEmpty()) {
            list.add(new RegExp.CharClass.Union(new RegExp.CharClass[0]));
        }
        return list.toArray(new RegExp[list.size()]);
    }
}

