/*
 * Decompiled with CFR 0.152.
 */
package org.rekex.regexp;

import java.util.function.Function;
import org.rekex.common_util.SwitchOnType;
import org.rekex.regexp.PkgUtil;
import org.rekex.regexp.RegExp;

class ToRegex {
    static int precedence = 0;
    static final int pAtomic = precedence--;
    static final int pQuant = precedence--;
    static final int pConcat = precedence--;
    static final int pAlt;
    static final int pRegex;
    static final int pRange;
    static final int pUnion;
    static final int pIntersect;
    static final Function<RegExp, PS> toPs;

    ToRegex() {
    }

    public static String regex(RegExp exp) {
        return ToRegex.strChild(pRegex, exp);
    }

    static String strChild(int parentPrecedence, RegExp child) {
        PS ps = toPs.apply(child);
        return ps.p < parentPrecedence ? ToRegex.addParens(ps) : ps.s;
    }

    static String addParens(PS ps) {
        if (ps.p <= pRange) {
            return "[" + ps.s + "]";
        }
        return "(?:" + ps.s + ")";
    }

    static PS join(int parentPrecedence, String op, RegExp[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(op);
            }
            sb.append(ToRegex.strChild(parentPrecedence, args[i]));
        }
        return new PS(parentPrecedence, sb.toString());
    }

    static PS onSingle(RegExp.CharClass.Single r) {
        String s = PkgUtil.esc(r.ch());
        return new PS(pAtomic, s);
    }

    static PS onRange(RegExp.CharClass.Range r) {
        String s = PkgUtil.esc(r.from()) + "-" + PkgUtil.esc(r.to());
        return new PS(pRange, s);
    }

    static PS onUnion(RegExp.CharClass.Union r) {
        RegExp[] args = r.args();
        if (args.length == 0) {
            return new PS(pIntersect, "0&&1");
        }
        if (args.length == 1) {
            return toPs.apply(args[0]);
        }
        return ToRegex.join(pUnion, "", args);
    }

    static PS onIntersection(RegExp.CharClass.Intersection r) {
        RegExp[] args = r.args();
        if (args.length == 0) {
            return ToRegex.onRange(new RegExp.CharClass.Range(0, 0x10FFFF));
        }
        if (args.length == 1) {
            return toPs.apply(args[0]);
        }
        return ToRegex.join(pIntersect, "&&", args);
    }

    static PS onNegation(RegExp.CharClass.Negation r) {
        Object s = ToRegex.toPs.apply((RegExp)r.arg()).s;
        s = "[^" + (String)s + "]";
        return new PS(pAtomic, (String)s);
    }

    static PS onPredefined(RegExp.CharClass.Predefined r) {
        return new PS(pAtomic, r.regex());
    }

    static PS onAlternation(RegExp.Alternation r) {
        RegExp[] args = r.args();
        if (args.length == 0) {
            return new PS(pAtomic, "(?!)");
        }
        if (args.length == 1) {
            return toPs.apply(args[0]);
        }
        return ToRegex.join(pAlt, "|", args);
    }

    static PS onConcatenation(RegExp.Concatenation r) {
        RegExp[] args = r.args();
        if (args.length == 0) {
            return new PS(pConcat, "");
        }
        if (args.length == 1) {
            return toPs.apply(args[0]);
        }
        return ToRegex.join(pConcat, "", args);
    }

    static PS onQuantified(RegExp.Quantified r) {
        Object s = ToRegex.strChild(1 + pQuant, r.arg());
        long min = r.min();
        long max = r.max();
        long INF = Long.MAX_VALUE;
        s = min == 0L && max == 1L ? (String)s + "?" : (min == 0L && max == Long.MAX_VALUE ? (String)s + "*" : (min == 1L && max == Long.MAX_VALUE ? (String)s + "+" : (min == max ? (String)s + "{" + min + "}" : (max == Long.MAX_VALUE ? (String)s + "{" + min + ",}" : (String)s + "{" + min + "," + max + "}"))));
        if (r.greediness() != '\u0000') {
            s = (String)s + r.greediness();
        }
        return new PS(pQuant, (String)s);
    }

    static PS onBoundary(RegExp.Boundary r) {
        return new PS(pAtomic, r.regex());
    }

    static PS onLookaround(RegExp.Lookaround r) {
        Object s = ToRegex.regex(r.arg());
        s = ToRegex.beginningOf(r) + (String)s + ")";
        return new PS(pAtomic, (String)s);
    }

    static String beginningOf(RegExp.Lookaround r) {
        return "(?" + (r.ahead() ? "" : "<") + (r.positive() ? "=" : "!");
    }

    static PS onBackReferenceWithNumber(RegExp.BackReference.WithNumber r) {
        String s = "\\" + r.number();
        return new PS(pAtomic, s);
    }

    static PS onBackReferenceWithName(RegExp.BackReference.WithName r) {
        String s = "\\k<" + r.name() + ">";
        return new PS(pAtomic, s);
    }

    static PS onGroupUnnamed(RegExp.Group.Unnamed r) {
        Object s = ToRegex.regex(r.arg());
        s = "(" + (String)s + ")";
        return new PS(pAtomic, (String)s);
    }

    static PS onGroupNamed(RegExp.Group.Named r) {
        Object s = ToRegex.regex(r.arg());
        s = "(?<" + r.name() + ">" + (String)s + ")";
        return new PS(pAtomic, (String)s);
    }

    static PS onAtomicGroup(RegExp.AtomicGroup r) {
        Object s = ToRegex.regex(r.arg());
        s = "(?>" + (String)s + ")";
        return new PS(pAtomic, (String)s);
    }

    static PS onFlagged(RegExp.Flagged r) {
        Object s = ToRegex.regex(r.arg());
        s = "(?" + ToRegex.flagsStr(r) + ":" + (String)s + ")";
        return new PS(pAtomic, (String)s);
    }

    static String flagsStr(RegExp.Flagged r) {
        Object flags = r.onFlags();
        if (!r.offFlags().isEmpty()) {
            flags = (String)flags + "-" + r.offFlags();
        }
        return flags;
    }

    public static PS onOpaque(RegExp.Opaque r) {
        return new PS(pRegex, r.regex());
    }

    static {
        pRegex = pAlt = precedence--;
        pRange = precedence--;
        pUnion = precedence--;
        pIntersect = precedence--;
        toPs = new SwitchOnType().on(RegExp.CharClass.Single.class, ToRegex::onSingle).on(RegExp.CharClass.Range.class, ToRegex::onRange).on(RegExp.CharClass.Union.class, ToRegex::onUnion).on(RegExp.CharClass.Intersection.class, ToRegex::onIntersection).on(RegExp.CharClass.Negation.class, ToRegex::onNegation).on(RegExp.CharClass.Predefined.class, ToRegex::onPredefined).on(RegExp.Alternation.class, ToRegex::onAlternation).on(RegExp.Concatenation.class, ToRegex::onConcatenation).on(RegExp.Quantified.class, ToRegex::onQuantified).on(RegExp.Boundary.class, ToRegex::onBoundary).on(RegExp.Lookaround.class, ToRegex::onLookaround).on(RegExp.BackReference.WithNumber.class, ToRegex::onBackReferenceWithNumber).on(RegExp.BackReference.WithName.class, ToRegex::onBackReferenceWithName).on(RegExp.Group.Unnamed.class, ToRegex::onGroupUnnamed).on(RegExp.Group.Named.class, ToRegex::onGroupNamed).on(RegExp.AtomicGroup.class, ToRegex::onAtomicGroup).on(RegExp.Flagged.class, ToRegex::onFlagged).on(RegExp.Opaque.class, ToRegex::onOpaque).complete(RegExp.class);
    }

    record PS(int p, String s) {
    }
}

