/*
 * Decompiled with CFR 0.152.
 */
package org.rekex.regexp;

import org.rekex.regexp.PkgUtil;
import org.rekex.regexp.RegExp;
import org.rekex.regexp.ToCountGroup;
import org.rekex.regexp.ToRegex;
import org.rekex.regexp.ToSimplify;
import org.rekex.regexp.ToTreeText;

public class RegExpApi {
    public static RegExp.CharClass ch(String chars) {
        return RegExpApi.union(RegExpApi.stringToCc(chars));
    }

    public static RegExp.CharClass.Range range(int from, int to) {
        return new RegExp.CharClass.Range(from, to);
    }

    public static RegExp.CharClass.Predefined predefined(String regex) {
        return new RegExp.CharClass.Predefined(regex);
    }

    public static RegExp.CharClass union(Object ... args) {
        RegExp.CharClass[] args2 = RegExpApi.arrayObjToCharClass(args);
        if (args2.length == 1) {
            return args2[0];
        }
        return new RegExp.CharClass.Union(args2);
    }

    public static RegExp.CharClass intersect(Object ... args) {
        RegExp.CharClass[] args2 = RegExpApi.arrayObjToCharClass(args);
        if (args2.length == 1) {
            return args2[0];
        }
        return new RegExp.CharClass.Intersection(args2);
    }

    public static RegExp.CharClass negate(Object arg) {
        RegExp.CharClass cc = RegExpApi.objToCharClass(arg, "arg");
        return new RegExp.CharClass.Negation(cc);
    }

    public static RegExp seq(Object ... args) {
        RegExp[] args2 = RegExpApi.arrayObjToRegExp(args);
        if (args2.length == 1) {
            return args2[0];
        }
        return new RegExp.Concatenation(args2);
    }

    public static RegExp alt(Object ... args) {
        RegExp[] args2 = RegExpApi.arrayObjToRegExp(args);
        if (args2.length == 1) {
            return args2[0];
        }
        return new RegExp.Alternation(args2);
    }

    public static RegExp.Quantified opt(Object ... sequence) {
        return RegExpApi.times(0, 1L, RegExpApi.seq(sequence));
    }

    public static RegExp.Quantified rep0(Object ... sequence) {
        return RegExpApi.times(0, Long.MAX_VALUE, RegExpApi.seq(sequence));
    }

    public static RegExp.Quantified rep1(Object ... sequence) {
        return RegExpApi.times(1, Long.MAX_VALUE, RegExpApi.seq(sequence));
    }

    public static RegExp.Quantified times(int n, RegExp exp) {
        return RegExpApi.times(n, n, exp);
    }

    public static RegExp.Quantified times(int min, long max, RegExp exp) {
        return new RegExp.Quantified(exp, min, max, '\u0000');
    }

    public static RegExp.Quantified reluctant(RegExp.Quantified q) {
        return new RegExp.Quantified(q.arg(), q.min(), q.max(), '?');
    }

    public static RegExp.Quantified possessive(RegExp.Quantified q) {
        return new RegExp.Quantified(q.arg(), q.min(), q.max(), '+');
    }

    public static RegExp.Group.Unnamed group(RegExp arg) {
        return new RegExp.Group.Unnamed(arg);
    }

    public static RegExp.Group.Named group(String name, RegExp arg) {
        return new RegExp.Group.Named(arg, name);
    }

    public static RegExp.AtomicGroup atomicGroup(RegExp arg) {
        return new RegExp.AtomicGroup(arg);
    }

    public static RegExp.BackReference.WithName backRef(String name) {
        return new RegExp.BackReference.WithName(name);
    }

    public static RegExp.BackReference.WithName backRef(RegExp.Group.Named namedGroup) {
        return RegExpApi.backRef(namedGroup.name());
    }

    public static RegExp.BackReference.WithNumber backRef(int number) {
        return new RegExp.BackReference.WithNumber(number);
    }

    public static RegExp.Flagged flag(boolean on, int flags, RegExp arg) {
        String flagStr = PkgUtil.flagBitsToStr(flags);
        return new RegExp.Flagged(arg, on ? flagStr : "", on ? "" : flagStr);
    }

    public static RegExp.Flagged ignoreCase(RegExp arg) {
        return RegExpApi.flag(true, 2, arg);
    }

    public static RegExp.Boundary boundary(String regex) {
        return new RegExp.Boundary(regex);
    }

    public static RegExp.Boundary boundary_beginning_of_line() {
        return RegExpApi.boundary("^");
    }

    public static RegExp.Boundary boundary_end_of_line() {
        return RegExpApi.boundary("$");
    }

    public static RegExp.Boundary boundary_word_boundary() {
        return RegExpApi.boundary("\\b");
    }

    public static RegExp.Boundary boundary_non_word_boundary() {
        return RegExpApi.boundary("\\B");
    }

    public static RegExp.Boundary boundary_beginning_of_input() {
        return RegExpApi.boundary("\\A");
    }

    public static RegExp.Boundary boundary_end_of_previous_match() {
        return RegExpApi.boundary("\\G");
    }

    public static RegExp.Boundary boundary_end_of_input_but_for_final_terminator() {
        return RegExpApi.boundary("\\Z");
    }

    public static RegExp.Boundary boundary_end_of_input() {
        return RegExpApi.boundary("\\z");
    }

    public static RegExp.Lookaround lookahead(boolean positive, RegExp arg) {
        return new RegExp.Lookaround(arg, true, positive);
    }

    public static RegExp.Lookaround lookbehind(boolean positive, RegExp arg) {
        return new RegExp.Lookaround(arg, false, positive);
    }

    public static RegExp.Opaque opaque(String regex) {
        return new RegExp.Opaque(regex);
    }

    public static RegExp simplify(RegExp exp) {
        return ToSimplify.simplify(exp);
    }

    public static String toRegex(RegExp exp) {
        return ToRegex.regex(exp);
    }

    public static String toTreeText(RegExp exp) {
        return ToTreeText.toTreeText(exp);
    }

    public static int findGroupNumberIn(RegExp.Group group, RegExp exp) {
        return ToCountGroup.findGroupNumberIn(group, exp);
    }

    static RegExp[] arrayObjToRegExp(Object ... args) {
        RegExp[] args2 = new RegExp[args.length];
        for (int i = 0; i < args.length; ++i) {
            args2[i] = RegExpApi.objToRegex(args[i]);
        }
        return args2;
    }

    static RegExp objToRegex(Object arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
        if (arg instanceof RegExp) {
            RegExp r = (RegExp)arg;
            return r;
        }
        if (arg instanceof Character) {
            Character c = (Character)arg;
            return new RegExp.CharClass.Single(c.charValue());
        }
        if (arg instanceof Integer) {
            Integer i = (Integer)arg;
            return new RegExp.CharClass.Single(i);
        }
        if (arg instanceof String) {
            String s = (String)arg;
            return RegExpApi.seq(RegExpApi.stringToCc(s));
        }
        throw new IllegalArgumentException("unexpected type: " + arg.getClass());
    }

    static RegExp.CharClass.Single[] stringToCc(String string) {
        return (RegExp.CharClass.Single[])string.codePoints().mapToObj(RegExp.CharClass.Single::new).toArray(RegExp.CharClass.Single[]::new);
    }

    static RegExp.CharClass exceptImpl(RegExp exp, Object[] args) {
        RegExp.CharClass thiz = RegExpApi.objToCharClass(exp, "exp");
        if (args.length == 0) {
            return thiz;
        }
        RegExp.CharClass neg = RegExpApi.negate(RegExpApi.union(args));
        return RegExpApi.intersect(thiz, neg);
    }

    static RegExp.CharClass objToCharClass(Object arg, String argDesc) {
        RegExp exp = RegExpApi.objToRegex(arg);
        if (!(exp instanceof RegExp.CharClass)) {
            exp = ToSimplify.simplify(exp);
        }
        if (exp instanceof RegExp.CharClass) {
            RegExp.CharClass cc = (RegExp.CharClass)exp;
            return cc;
        }
        throw new IllegalArgumentException(argDesc + " is not a CharClass: " + arg);
    }

    static RegExp.CharClass[] arrayObjToCharClass(Object ... args) {
        RegExp.CharClass[] args2 = new RegExp.CharClass[args.length];
        for (int i = 0; i < args.length; ++i) {
            args2[i] = RegExpApi.objToCharClass(args[i], "args[" + i + "]");
        }
        return args2;
    }
}

