/*
 * Decompiled with CFR 0.152.
 */
package org.rekex.regexp;

import org.rekex.regexp.PkgUtil;
import org.rekex.regexp.RegExpApi;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RegExp {
    default public CharClass except(Object ... args) {
        return RegExpApi.exceptImpl(this, args);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CharClass
    extends RegExp {

        public record Predefined(String regex) implements CharClass
        {
            public Predefined {
                PkgUtil.validateRegex(regex);
            }
        }

        public record Negation(CharClass arg) implements CharClass
        {
        }

        public record Intersection(CharClass[] args) implements CharClass
        {
        }

        public record Union(CharClass[] args) implements CharClass
        {
        }

        public record Range(int from, int to) implements CharClass
        {
            public Range {
                Single.validate(from, "from");
                Single.validate(to, "to");
                if (from > to) {
                    throw new IllegalArgumentException("required: from<=to");
                }
            }
        }

        public record Single(int ch) implements CharClass
        {
            public Single {
                Single.validate(ch, "ch");
            }

            static void validate(int ch, String name) {
                if (!Character.isValidCodePoint(ch)) {
                    throw new IllegalArgumentException(name + " is not a valid code point: " + Integer.toHexString(ch));
                }
                if (55296 <= ch && ch <= 57343) {
                    throw new IllegalArgumentException(name + " is a lone surrogate: " + Integer.toHexString(ch));
                }
            }
        }
    }

    public record Opaque(String regex) implements RegExp
    {
        public Opaque {
            PkgUtil.validateRegex(regex);
        }
    }

    public record Flagged(RegExp arg, String onFlags, String offFlags) implements RegExp
    {
    }

    public record AtomicGroup(RegExp arg) implements RegExp
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Group
    extends RegExp {
        public RegExp arg();

        public record Named(RegExp arg, String name) implements Group
        {
            public Named {
                Named.validateName(name);
            }

            public static void validateName(String name) {
                if (!PkgUtil.isValidGroupName(name)) {
                    throw new IllegalArgumentException("invalid group name: " + name);
                }
            }
        }

        public record Unnamed(RegExp arg) implements Group
        {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BackReference
    extends RegExp {

        public record WithName(String name) implements BackReference
        {
            public WithName {
                Group.Named.validateName(name);
            }
        }

        public record WithNumber(int number) implements BackReference
        {
            public WithNumber {
                if (number <= 0) {
                    throw new IllegalArgumentException("invalid group number: " + number);
                }
            }
        }
    }

    public record Lookaround(RegExp arg, boolean ahead, boolean positive) implements RegExp
    {
    }

    public record Boundary(String regex) implements RegExp
    {
        public Boundary {
            PkgUtil.validateRegex(regex);
        }
    }

    public record Quantified(RegExp arg, long min, long max, char greediness) implements RegExp
    {
        public static final long INFINITY = Long.MAX_VALUE;
        public static final char greedy = '\u0000';
        public static final char reluctant = '?';
        public static final char possessive = '+';

        public Quantified {
            if (0L > min || min > max) {
                throw new IllegalArgumentException("invalid min-max: " + min + "-" + max);
            }
        }
    }

    public record Concatenation(RegExp[] args) implements RegExp
    {
    }

    public record Alternation(RegExp[] args) implements RegExp
    {
    }
}

