/*
 * Decompiled with CFR 0.152.
 */
package org.rekex.regexp;

import java.util.regex.Pattern;

class PkgUtil {
    static final String[] ESC;
    static final int[][] flagMap;

    PkgUtil() {
    }

    static char h(int x) {
        return "0123456789ABCDEF".charAt(x & 0xF);
    }

    static String escHex4(char ch) {
        return "\\u" + PkgUtil.h(ch >> 12) + PkgUtil.h(ch >> 8) + PkgUtil.h(ch >> 4) + PkgUtil.h(ch);
    }

    public static String esc(int ch) {
        if (ch < ESC.length) {
            return ESC[ch];
        }
        if (ch <= 65535) {
            return PkgUtil.escHex4((char)ch);
        }
        return "\\x{" + Integer.toHexString(ch).toUpperCase() + "}";
    }

    static void validateRegex(String regex) {
        Pattern.compile(regex);
    }

    static boolean isValidGroupName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (!PkgUtil.isLetter(name.charAt(0))) {
            return false;
        }
        return name.chars().allMatch(ch -> PkgUtil.isLetter(ch) || PkgUtil.isDigit(ch));
    }

    static boolean isLetter(int ch) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122;
    }

    static boolean isDigit(int ch) {
        return 48 <= ch && ch <= 57;
    }

    static String flagBitsToStr(int flags) {
        Object s = "";
        for (int[] char_int : flagMap) {
            char c = (char)char_int[0];
            int i = char_int[1];
            if ((flags & i) == 0) continue;
            s = (String)s + c;
            flags ^= i;
        }
        if (flags != 0) {
            throw new IllegalArgumentException("unexpected flags: " + Integer.toBinaryString(flags));
        }
        return s;
    }

    static {
        char ch;
        ESC = new String[256];
        for (ch = '\u0000'; ch <= '\u00ff'; ch = (char)(ch + '\u0001')) {
            PkgUtil.ESC[ch] = PkgUtil.escHex4(ch);
        }
        PkgUtil.ESC[9] = "\\t";
        PkgUtil.ESC[10] = "\\n";
        PkgUtil.ESC[13] = "\\r";
        PkgUtil.ESC[12] = "\\f";
        PkgUtil.ESC[7] = "\\a";
        PkgUtil.ESC[27] = "\\e";
        PkgUtil.ESC[32] = "\\ ";
        for (ch = '!'; ch <= '~'; ch = (char)(ch + '\u0001')) {
            PkgUtil.ESC[ch] = "" + ch;
        }
        for (char op : "\\[]^-&.$?*+{}|()".toCharArray()) {
            PkgUtil.ESC[op] = "\\" + op;
        }
        flagMap = new int[][]{{105, 2}, {100, 1}, {109, 8}, {115, 32}, {117, 64}, {120, 4}, {85, 256}};
    }
}

