/*
 * Decompiled with CFR 0.152.
 */
package redradishes.guava;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import redradishes.guava.RedisClient;

public class RedisClientFactory
implements AutoCloseable {
    private final Pool<ByteBuffer> byteBufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 0x100000);
    private final Charset charset;
    private final XnioWorker worker;

    public RedisClientFactory(Charset charset, int ioThreads) throws IOException {
        Xnio xnio = Xnio.getInstance();
        this.charset = charset;
        this.worker = xnio.createWorker(OptionMap.create((Option)Options.WORKER_IO_THREADS, (Object)ioThreads));
    }

    public RedisClient connect(SocketAddress address) {
        return new RedisClient(this.worker, address, this.byteBufferPool, this.charset);
    }

    @Override
    public void close() {
        this.worker.shutdown();
    }
}

