/*
 * Decompiled with CFR 0.152.
 */
package redradishes.guava;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xnio.IoFuture;

class IoFutureAdapter<T>
implements ListenableFuture<T> {
    private final IoFuture<T> ioFuture;

    public IoFutureAdapter(IoFuture<T> ioFuture) {
        this.ioFuture = ioFuture;
    }

    public void addListener(Runnable listener, Executor executor) {
        this.ioFuture.addNotifier((ioFuture, attachment) -> executor.execute(listener), null);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.ioFuture.cancel();
        return this.ioFuture.getStatus() != IoFuture.Status.DONE;
    }

    public boolean isCancelled() {
        return this.ioFuture.getStatus() == IoFuture.Status.CANCELLED;
    }

    public boolean isDone() {
        return this.ioFuture.getStatus() == IoFuture.Status.DONE;
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.ioFuture.getInterruptibly();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        switch (this.ioFuture.awaitInterruptibly(timeout, unit)) {
            case WAITING: {
                throw new TimeoutException();
            }
            case CANCELLED: {
                throw new CancellationException();
            }
            case FAILED: {
                throw new ExecutionException(this.ioFuture.getException());
            }
        }
        try {
            return (T)this.ioFuture.getInterruptibly();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }
}

