/*
 * Decompiled with CFR 0.152.
 */
package redradishes.guava;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import redradishes.decoder.ArrayBuilderFactory;
import redradishes.decoder.MapBuilderFactory;

public class CollectionBuilders {
    public static <E> ArrayBuilderFactory<E, ImmutableList<E>> immutableList() {
        return length -> new ArrayBuilderFactory.Builder<E, ImmutableList<E>>(){
            private final ImmutableList.Builder builder = ImmutableList.builder();

            @Override
            public void add(E element) {
                this.builder.add(element);
            }

            @Override
            public ImmutableList<E> build() {
                return this.builder.build();
            }
        };
    }

    public static <K, V> MapBuilderFactory<K, V, ImmutableMap<K, V>> immutableMap() {
        return length -> new MapBuilderFactory.Builder<K, V, ImmutableMap<K, V>>(){
            private final ImmutableMap.Builder builder = ImmutableMap.builder();

            @Override
            public void put(K key, V value) {
                this.builder.put(key, value);
            }

            @Override
            public ImmutableMap<K, V> build() {
                return this.builder.build();
            }
        };
    }
}

