/*
 * Decompiled with CFR 0.152.
 */
package redradishes.encoder;

import com.google.common.base.Utf8;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import redradishes.UncheckedCharacterCodingException;
import redradishes.encoder.ConstExpr;
import redradishes.encoder.Encoder;
import redradishes.encoder.IntEncoder;

public class RespEncoders {
    private static final byte[][] NUM_BYTES = (byte[][])IntStream.rangeClosed(10, 99).mapToObj(i -> Integer.toString(i).getBytes(StandardCharsets.US_ASCII)).toArray(x$0 -> new byte[x$0][]);
    private static final byte[] MIN_LONG_BYTES = "-9223372036854775808".getBytes(StandardCharsets.US_ASCII);
    private static final long[] SIZE_TABLE = LongStream.iterate(10L, x -> x * 10L).limit(18L).map(x -> x - 1L).toArray();
    private static final ConstExpr CR_LF = ConstExpr.bytesConst(new byte[]{13, 10});
    private static final ConstExpr MIN_LONG_BULK_STRING = RespEncoders.charConst('2').append(RespEncoders.charConst('0')).append(CR_LF).append(ConstExpr.bytesConst(MIN_LONG_BYTES)).compact();
    private static final ConstExpr EMPTY_BULK_STRING = RespEncoders.charConst('0').append(CR_LF).compact();
    private static final IntEncoder ONE_DIGIT_AS_BULK_STRING = RespEncoders.charConst('1').append(CR_LF).append(IntEncoder.digitEncoder());
    private static final IntEncoder TWO_DIGITS_AS_BULK_STRING = RespEncoders.charConst('2').append(CR_LF).append(Encoder.bytesEnc().mapToIntEncoder(num -> NUM_BYTES[num - 10]));
    private static final IntEncoder ARRAY = RespEncoders.charConst('*').append(RespEncoders.intEnc()).append(CR_LF).compact();
    private static final ThreadLocal<Map<Charset, CharsetEncoder>> charsetDecodersMap = new ThreadLocal<Map<Charset, CharsetEncoder>>(){

        @Override
        protected Map<Charset, CharsetEncoder> initialValue() {
            return new WeakHashMap<Charset, CharsetEncoder>();
        }
    };

    public static IntEncoder array() {
        return ARRAY;
    }

    private static ConstExpr charConst(char c) {
        return ConstExpr.byteConst((byte)c);
    }

    public static Encoder<CharSequence> strBulkString(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return ConstExpr.NEW_ARG.append(Encoder.choiceConst(s -> s.length() == 0, EMPTY_BULK_STRING, RespEncoders.intEnc().map(Utf8::encodedLength).append(CR_LF).zip(Encoder.stringEnc(charset)))).append(CR_LF);
        }
        CharsetEncoder charsetEncoder = RespEncoders.getCharsetEncoder(charset);
        if ((double)charsetEncoder.maxBytesPerChar() == 1.0) {
            return ConstExpr.NEW_ARG.append(Encoder.choiceConst(s -> s.length() == 0, EMPTY_BULK_STRING, RespEncoders.intEnc().map(CharSequence::length).append(CR_LF).zip(Encoder.stringEnc(charset)))).append(CR_LF);
        }
        return ConstExpr.NEW_ARG.append(s -> {
            if (s.length() == 0) {
                return EMPTY_BULK_STRING;
            }
            try {
                ByteBuffer byteBuffer = RespEncoders.encodeCharSeq(s, charsetEncoder);
                int encodedLength = byteBuffer.remaining();
                return RespEncoders.intEnc().encode(encodedLength).append(CR_LF).append(ConstExpr.bytesConst(byteBuffer.array(), 0, encodedLength));
            }
            catch (CharacterCodingException e) {
                throw new UncheckedCharacterCodingException(e);
            }
        }).append(CR_LF);
    }

    static CharsetEncoder getCharsetEncoder(Charset charset) {
        return charsetDecodersMap.get().computeIfAbsent(charset, Charset::newEncoder);
    }

    private static ByteBuffer encodeCharSeq(CharSequence s, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        int maxLength = (int)((double)s.length() * (double)charsetEncoder.maxBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(maxLength);
        CharBuffer charBuffer = CharBuffer.wrap(s);
        CoderResult coderResult = charsetEncoder.reset().encode(charBuffer, byteBuffer, true);
        if (coderResult.isUnderflow()) {
            coderResult = charsetEncoder.flush(byteBuffer);
        }
        if (!coderResult.isUnderflow()) {
            coderResult.throwException();
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static Encoder<byte[]> bytesBulkString() {
        return ConstExpr.NEW_ARG.append(RespEncoders.arrayLenEnc()).append(CR_LF).zip(Encoder.bytesEnc()).append(CR_LF);
    }

    private static Encoder<byte[]> arrayLenEnc() {
        return RespEncoders.intEnc().map(arr -> ((byte[])arr).length);
    }

    public static Encoder<Integer> intBulkString() {
        return ConstExpr.NEW_ARG.append(IntEncoder.choice(num -> num >= 0 && num <= 9, ONE_DIGIT_AS_BULK_STRING, IntEncoder.choice(num -> num >= 10 && num <= 99, TWO_DIGITS_AS_BULK_STRING, RespEncoders.longAsBulkString().mapToIntEncoder(Long::valueOf))).map(Integer::intValue)).append(CR_LF);
    }

    public static Encoder<Long> longBulkString() {
        return ConstExpr.NEW_ARG.append(Encoder.choice(num -> num >= 0L && num <= 9L, ONE_DIGIT_AS_BULK_STRING.map(Long::intValue), Encoder.choice(num -> num >= 10L && num <= 99L, TWO_DIGITS_AS_BULK_STRING.map(Long::intValue), Encoder.choiceConst(num -> num == Long.MIN_VALUE, MIN_LONG_BULK_STRING, RespEncoders.longAsBulkString())))).append(CR_LF);
    }

    private static Encoder<Long> longAsBulkString() {
        return num -> {
            byte[] bytes = RespEncoders.toBytes(num);
            int len = bytes.length;
            return (len <= 9 ? ConstExpr.byteConst((byte)(48 + len)) : ConstExpr.bytesConst(NUM_BYTES[len - 10])).append(CR_LF).append(ConstExpr.bytesConst(bytes));
        };
    }

    private static IntEncoder intEnc() {
        return num -> {
            if (num >= 0 && num <= 9) {
                return ConstExpr.byteConst((byte)(48 + num));
            }
            if (num >= 10 && num <= 99) {
                return ConstExpr.bytesConst(NUM_BYTES[num - 10]);
            }
            return ConstExpr.bytesConst(RespEncoders.toBytes(num));
        };
    }

    static byte[] toBytes(long num) {
        boolean neg;
        if (num == Long.MIN_VALUE) {
            return MIN_LONG_BYTES;
        }
        boolean bl = neg = num < 0L;
        if (neg) {
            num = -num;
        }
        int size = neg ? RespEncoders.stringSize(num) + 1 : RespEncoders.stringSize(num);
        byte[] buf = new byte[size];
        if (neg) {
            buf[0] = 45;
        }
        int i = size - 1;
        while (num != 0L) {
            buf[i--] = (byte)(48L + num % 10L);
            num /= 10L;
        }
        return buf;
    }

    private static int stringSize(long x) {
        for (int i = 0; i < SIZE_TABLE.length; ++i) {
            if (x > SIZE_TABLE[i]) continue;
            return i + 1;
        }
        return 19;
    }
}

