/*
 * Decompiled with CFR 0.152.
 */
package redradishes.encoder;

import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;
import redradishes.encoder.ConstExpr;
import redradishes.encoder.Encoder;
import redradishes.encoder.EncoderBase;

public interface IntEncoder
extends EncoderBase<IntEncoder> {
    public ConstExpr encode(int var1);

    @Override
    default public IntEncoder prepend(final ConstExpr c) {
        return new IntEncoder(){

            @Override
            public ConstExpr encode(int val) {
                return ConstExpr.combine(c, IntEncoder.this.encode(val));
            }

            @Override
            public IntEncoder compact() {
                return IntEncoder.this.compact().prepend(c.compact());
            }
        };
    }

    @Override
    default public IntEncoder append(final ConstExpr c) {
        return new IntEncoder(){

            @Override
            public ConstExpr encode(int val) {
                return ConstExpr.combine(IntEncoder.this.encode(val), c);
            }

            @Override
            public IntEncoder compact() {
                return IntEncoder.this.compact().append(c.compact());
            }
        };
    }

    @Override
    default public IntEncoder compact() {
        return this;
    }

    default public <U> Encoder<U> map(final ToIntFunction<? super U> mapper) {
        return new Encoder<U>(){

            @Override
            public ConstExpr encode(U val) {
                return IntEncoder.this.encode(mapper.applyAsInt(val));
            }

            @Override
            public Encoder<U> compact() {
                return IntEncoder.this.compact().map(mapper);
            }
        };
    }

    public static IntEncoder digitEncoder() {
        return i -> ConstExpr.byteConst((byte)(48 + i));
    }

    public static IntEncoder choice(final IntPredicate predicate, final IntEncoder then, final IntEncoder otherwise) {
        return new IntEncoder(){

            @Override
            public ConstExpr encode(int val) {
                return predicate.test(val) ? then.encode(val) : otherwise.encode(val);
            }

            @Override
            public IntEncoder compact() {
                return IntEncoder.choice(predicate, then.compact(), otherwise.compact());
            }
        };
    }
}

