/*
 * Decompiled with CFR 0.152.
 */
package redradishes.encoder;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import redradishes.encoder.ConstExpr;
import redradishes.encoder.Encoder;
import redradishes.encoder.RespEncoders;

public class Encoders {
    public static Encoder<CharSequence> strArg(Charset charset) {
        return RespEncoders.strBulkString(charset);
    }

    public static Encoder<Long> longArg() {
        return RespEncoders.longBulkString();
    }

    public static Encoder<Integer> intArg() {
        return RespEncoders.intBulkString();
    }

    public static Encoder<byte[]> bytesArg() {
        return RespEncoders.bytesBulkString();
    }

    public static Encoder<long[]> longArrayArg() {
        return es -> Arrays.stream(es).mapToObj(e -> RespEncoders.longBulkString().encode(e)).reduce(ConstExpr.EMPTY, ConstExpr::append);
    }

    public static Encoder<int[]> intArrayArg() {
        return es -> Arrays.stream(es).mapToObj(e -> RespEncoders.intBulkString().encode(e)).reduce(ConstExpr.EMPTY, ConstExpr::append);
    }

    public static <E> Encoder<E[]> arrayArg(Encoder<? super E> elemEncoder) {
        return es -> Arrays.stream(es).map(elemEncoder::encode).reduce(ConstExpr.EMPTY, ConstExpr::append);
    }

    public static <E> Encoder<Collection<? extends E>> collArg(Encoder<? super E> elemEncoder) {
        return es -> es.stream().map(elemEncoder::encode).reduce(ConstExpr.EMPTY, ConstExpr::append);
    }

    public static <K, V> Encoder<Map<? extends K, ? extends V>> mapArg(Encoder<? super K> keyEncoder, Encoder<? super V> valueEncoder) {
        return es -> es.entrySet().stream().map(e -> keyEncoder.encode((Object)e.getKey()).append(valueEncoder.encode((Object)e.getValue()))).reduce(ConstExpr.EMPTY, ConstExpr::append);
    }
}

