/*
 * Decompiled with CFR 0.152.
 */
package redradishes.encoder;

import java.nio.charset.Charset;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import redradishes.encoder.ConstExpr;
import redradishes.encoder.Encoder2;
import redradishes.encoder.EncoderBase;
import redradishes.encoder.IntEncoder;

public interface Encoder<T>
extends EncoderBase<Encoder<T>> {
    public ConstExpr encode(T var1);

    @Override
    default public Encoder<T> prepend(final ConstExpr c) {
        return new Encoder<T>(){

            @Override
            public ConstExpr encode(T val) {
                return ConstExpr.combine(c, Encoder.this.encode(val));
            }

            @Override
            public Encoder<T> compact() {
                return Encoder.this.compact().prepend(c.compact());
            }
        };
    }

    @Override
    default public Encoder<T> append(final ConstExpr c) {
        return new Encoder<T>(){

            @Override
            public ConstExpr encode(T val) {
                return ConstExpr.combine(Encoder.this.encode(val), c);
            }

            @Override
            public Encoder<T> compact() {
                return Encoder.this.compact().append(c.compact());
            }
        };
    }

    @Override
    default public Encoder<T> compact() {
        return this;
    }

    default public <T2> Encoder2<T, T2> append(final Encoder<T2> other) {
        return new Encoder2<T, T2>(){

            @Override
            public ConstExpr encode(T val1, T2 val2) {
                return Encoder.this.encode(val1).append(other.encode(val2));
            }

            @Override
            public Encoder2<T, T2> compact() {
                return Encoder.this.compact().append(other.compact());
            }
        };
    }

    default public Encoder<T> zip(final Encoder<T> enc2) {
        return new Encoder<T>(){

            @Override
            public ConstExpr encode(T val) {
                return Encoder.this.encode(val).append(enc2.encode(val));
            }

            @Override
            public Encoder<T> compact() {
                return Encoder.this.compact().zip(enc2.compact());
            }
        };
    }

    default public IntEncoder mapToIntEncoder(final IntFunction<? extends T> mapper) {
        return new IntEncoder(){

            @Override
            public ConstExpr encode(int val) {
                return Encoder.this.encode(mapper.apply(val));
            }

            @Override
            public IntEncoder compact() {
                return Encoder.this.compact().mapToIntEncoder(mapper);
            }
        };
    }

    public static Encoder<byte[]> bytesEnc() {
        return ConstExpr::bytesConst;
    }

    public static Encoder<CharSequence> stringEnc(Charset charset) {
        return val -> ConstExpr.strConst(val, charset);
    }

    public static <T> Encoder<T> choice(final Predicate<T> predicate, final Encoder<T> then, final Encoder<T> otherwise) {
        return new Encoder<T>(){

            @Override
            public ConstExpr encode(T val) {
                return predicate.test(val) ? then.encode(val) : otherwise.encode(val);
            }

            @Override
            public Encoder<T> compact() {
                return Encoder.choice(predicate, then.compact(), otherwise.compact());
            }
        };
    }

    public static <T> Encoder<T> choiceConst(final Predicate<T> predicate, final ConstExpr then, final Encoder<T> otherwise) {
        return new Encoder<T>(){

            @Override
            public ConstExpr encode(T val) {
                return predicate.test(val) ? then : otherwise.encode(val);
            }

            @Override
            public Encoder<T> compact() {
                return Encoder.choiceConst(predicate, then.compact(), otherwise.compact());
            }
        };
    }
}

