/*
 * Decompiled with CFR 0.152.
 */
package redradishes.encoder;

import com.google.common.base.Utf8;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import redradishes.UncheckedCharacterCodingException;
import redradishes.encoder.ByteSink;
import redradishes.encoder.EncoderBase;
import redradishes.encoder.RespEncoders;

public interface ConstExpr {
    public static final ConstExpr EMPTY = new ConstExpr(){

        @Override
        public int length() {
            return 0;
        }

        @Override
        public void writeTo(ByteSink byteSink) {
        }

        @Override
        public int size() {
            return 0;
        }
    };
    public static final ConstExpr NEW_ARG = new ConstExpr(){

        @Override
        public int length() {
            return 1;
        }

        @Override
        public void writeTo(ByteSink byteSink) {
            byteSink.write((byte)36);
        }

        @Override
        public int size() {
            return 1;
        }
    };

    public int length();

    public void writeTo(ByteSink var1);

    public int size();

    default public ConstExpr compact() {
        return this;
    }

    default public <E extends EncoderBase<E>> E append(E enc) {
        return enc.prepend(this);
    }

    default public ConstExpr append(ConstExpr c) {
        return ConstExpr.combine(this, c);
    }

    public static ConstExpr byteConst(final byte b) {
        return new ConstExpr(){

            @Override
            public int length() {
                return 1;
            }

            @Override
            public void writeTo(ByteSink byteSink) {
                byteSink.write(b);
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    public static ConstExpr bytesConst(byte[] src) {
        return ConstExpr.bytesConstWithSize(src, 0);
    }

    public static ConstExpr bytesConstWithSize(final byte[] src, final int size) {
        return new ConstExpr(){

            @Override
            public int length() {
                return src.length;
            }

            @Override
            public void writeTo(ByteSink byteSink) {
                byteSink.write(src);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static ConstExpr bytesConst(final byte[] src, final int offset, final int length) {
        return new ConstExpr(){

            @Override
            public int length() {
                return length;
            }

            @Override
            public void writeTo(ByteSink byteSink) {
                byteSink.write(src, offset, length);
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    public static ConstExpr strConst(final CharSequence s, final Charset charset) {
        return new ConstExpr(){

            @Override
            public int length() {
                if (s.length() == 0) {
                    return 0;
                }
                if (StandardCharsets.UTF_8.equals(charset)) {
                    return Utf8.encodedLength((CharSequence)s);
                }
                CharsetEncoder charsetEncoder = RespEncoders.getCharsetEncoder(charset);
                if ((double)charsetEncoder.maxBytesPerChar() == 1.0) {
                    return s.length();
                }
                CharBuffer charBuffer = CharBuffer.wrap(s);
                try {
                    return charsetEncoder.encode(charBuffer).remaining();
                }
                catch (CharacterCodingException e) {
                    throw new UncheckedCharacterCodingException(e);
                }
            }

            @Override
            public void writeTo(ByteSink byteSink) {
                byteSink.write(s, RespEncoders.getCharsetEncoder(charset));
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public ConstExpr compact() {
                try {
                    ByteBuffer byteBuffer = RespEncoders.getCharsetEncoder(charset).encode(CharBuffer.wrap(s));
                    return ConstExpr.bytesConst(byteBuffer.array(), 0, byteBuffer.remaining());
                }
                catch (CharacterCodingException e) {
                    throw new UncheckedCharacterCodingException(e);
                }
            }
        };
    }

    public static ConstExpr combine(final ConstExpr c1, final ConstExpr c2) {
        return new ConstExpr(){

            @Override
            public int length() {
                return c1.length() + c2.length();
            }

            @Override
            public void writeTo(ByteSink byteSink) {
                c1.writeTo(byteSink);
                c2.writeTo(byteSink);
            }

            @Override
            public int size() {
                return c1.size() + c2.size();
            }

            @Override
            public ConstExpr compact() {
                final ByteArrayOutputStream out = new ByteArrayOutputStream(this.length());
                ByteSink sink = new ByteSink(){

                    @Override
                    public void write(byte b) {
                        out.write(b);
                    }

                    @Override
                    public void write(CharSequence s, CharsetEncoder charsetEncoder) {
                        try {
                            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(s));
                            out.write(byteBuffer.array(), 0, byteBuffer.remaining());
                        }
                        catch (CharacterCodingException e) {
                            throw new UncheckedCharacterCodingException(e);
                        }
                    }

                    @Override
                    public void write(byte[] src) {
                        out.write(src, 0, src.length);
                    }

                    @Override
                    public void write(byte[] src, int offset, int length) {
                        out.write(src, offset, length);
                    }
                };
                c1.writeTo(sink);
                c2.writeTo(sink);
                byte[] bytes = out.toByteArray();
                return ConstExpr.bytesConstWithSize(bytes, this.size());
            }
        };
    }
}

