/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import javax.annotation.Nullable;
import redradishes.decoder.ArrayBuilderFactory;
import redradishes.decoder.BulkStringBuilderFactory;
import redradishes.decoder.ReplyParseException;
import redradishes.decoder.parser.AnyReplyParser;
import redradishes.decoder.parser.ArrayParser;
import redradishes.decoder.parser.BulkStringParser;
import redradishes.decoder.parser.CharAppendingParser;
import redradishes.decoder.parser.LenParser;
import redradishes.decoder.parser.LongParser;
import redradishes.decoder.parser.Parser;
import redradishes.decoder.parser.ReplyParser;

class UnexpectedReplyTypeParsers {
    private static final Appendable NOOP_APPENDABLE = new Appendable(){

        @Override
        public Appendable append(CharSequence csq) {
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            return this;
        }

        @Override
        public Appendable append(char c) {
            return this;
        }
    };
    private static final ReplyParser<Appendable> NOOP_SIMPLE_STRING_PARSER = new CharAppendingParser<Appendable>(() -> NOOP_APPENDABLE);
    private static final Parser<?> NOOP_INTEGER_PARSER = LongParser.PARSER.mapToParser(num -> null);
    private static final BulkStringBuilderFactory<?, ?> NOOP_BULK_STRING_BUILDER_FACTORY = UnexpectedReplyTypeParsers.noopBulkStringBuilderFactory();
    private static final ReplyParser<?> NOOP_BULK_STRING_PARSER = new LenParser(len -> new BulkStringParser(len, NOOP_BULK_STRING_BUILDER_FACTORY));
    private static final ArrayBuilderFactory.Builder<Object, ?> NOOP_ARRAY_BUILDER_FACTORY = UnexpectedReplyTypeParsers.noopArrayBuilderFactory();
    private static final ReplyParser<?> NOOP_ARRAY_PARSER = UnexpectedReplyTypeParsers.noopArrayParser();
    private static final ReplyParser<Object> NOOP_ANY_REPLY_PARSER = new AnyReplyParser<Appendable>(NOOP_SIMPLE_STRING_PARSER, NOOP_SIMPLE_STRING_PARSER, NOOP_INTEGER_PARSER, NOOP_BULK_STRING_PARSER, NOOP_ARRAY_PARSER);
    private final String unexpectedSimpleStringMeggage;
    private final String unexpectedBulkStringMeggage;
    private final String unexpectedIntegerMessage;
    private final String unexpectedArrayMessage;

    UnexpectedReplyTypeParsers(String expectedType) {
        this.unexpectedSimpleStringMeggage = UnexpectedReplyTypeParsers.wrongType("simple string", expectedType);
        this.unexpectedBulkStringMeggage = UnexpectedReplyTypeParsers.wrongType("bulk string", expectedType);
        this.unexpectedIntegerMessage = UnexpectedReplyTypeParsers.wrongType("integer", expectedType);
        this.unexpectedArrayMessage = UnexpectedReplyTypeParsers.wrongType("array", expectedType);
    }

    private static String wrongType(String actualTupe, String expectedType) {
        return String.format("Command returned %s reply while %s reply was expected", actualTupe, expectedType);
    }

    <T> ReplyParser<T> simpleStringParser() {
        return NOOP_SIMPLE_STRING_PARSER.fail(new ReplyParseException(this.unexpectedSimpleStringMeggage));
    }

    <T> ReplyParser<T> nilBulkStringParser() {
        return new LenParser(len -> new BulkStringParser(len, NOOP_BULK_STRING_BUILDER_FACTORY).fail(new ReplyParseException(this.unexpectedBulkStringMeggage)));
    }

    <T> ReplyParser<T> integerParser() {
        return NOOP_INTEGER_PARSER.fail(new ReplyParseException(this.unexpectedIntegerMessage));
    }

    <T> ReplyParser<T> arrayParser() {
        return NOOP_ARRAY_PARSER.fail(new ReplyParseException(this.unexpectedArrayMessage));
    }

    private static <B, R> BulkStringBuilderFactory<B, R> noopBulkStringBuilderFactory() {
        return new BulkStringBuilderFactory<B, R>(){

            @Override
            public B create(int length, CharsetDecoder charsetDecoder) {
                return null;
            }

            @Override
            public B append(B builder, ByteBuffer buffer, CharsetDecoder charsetDecoder) throws Exception {
                buffer.position(buffer.limit());
                return builder;
            }

            @Override
            public R appendLast(B builder, ByteBuffer buffer, CharsetDecoder charsetDecoder) throws Exception {
                buffer.position(buffer.limit());
                return null;
            }
        };
    }

    private static <E, T> ArrayBuilderFactory.Builder<E, T> noopArrayBuilderFactory() {
        return new ArrayBuilderFactory.Builder<E, T>(){

            @Override
            public void add(@Nullable E element) {
            }

            @Override
            public T build() {
                return null;
            }
        };
    }

    private static ReplyParser<?> noopArrayParser() {
        return new LenParser(len -> new ArrayParser(len, length -> NOOP_ARRAY_BUILDER_FACTORY, NOOP_ANY_REPLY_PARSER));
    }
}

