/*
 * Decompiled with CFR 0.152.
 */
package redradishes.decoder.parser;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.Function;
import java.util.function.LongFunction;
import redradishes.decoder.parser.Parser;

public abstract class LongParser {
    static final LongParser PARSER = new LongParser(){

        @Override
        <T> T parse(ByteBuffer buffer, LongFunction<T> resultHandler, PartialHandler<T> partialHandler) {
            return (T)LongParser.doParse(buffer, resultHandler, partialHandler, false, 0L, 0);
        }
    };
    public static final Parser<Integer> INTEGER_PARSER = PARSER.mapToParser(l -> (int)l);
    public static final Parser<Long> LONG_PARSER = PARSER.mapToParser(l -> l);
    private static final int SIGN_OR_DIGIT = 0;
    private static final int DIGIT = 1;
    private static final int WAITING_FOR_LF = 2;

    abstract <T> T parse(ByteBuffer var1, LongFunction<T> var2, PartialHandler<T> var3);

    private static <T> T doParse(ByteBuffer buffer, LongFunction<T> resultHandler, PartialHandler<T> partialHandler, boolean negative, long num, int state) {
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            block0 : switch (state) {
                case 0: {
                    state = 1;
                    if (b == 45) {
                        negative = true;
                        break;
                    }
                }
                case 1: {
                    switch (b) {
                        case 48: {
                            num *= 10L;
                            break block0;
                        }
                        case 49: {
                            num = num * 10L + 1L;
                            break block0;
                        }
                        case 50: {
                            num = num * 10L + 2L;
                            break block0;
                        }
                        case 51: {
                            num = num * 10L + 3L;
                            break block0;
                        }
                        case 52: {
                            num = num * 10L + 4L;
                            break block0;
                        }
                        case 53: {
                            num = num * 10L + 5L;
                            break block0;
                        }
                        case 54: {
                            num = num * 10L + 6L;
                            break block0;
                        }
                        case 55: {
                            num = num * 10L + 7L;
                            break block0;
                        }
                        case 56: {
                            num = num * 10L + 8L;
                            break block0;
                        }
                        case 57: {
                            num = num * 10L + 9L;
                            break block0;
                        }
                        case 13: {
                            state = 2;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected character: " + (char)b);
                }
                case 2: {
                    if (b == 10) {
                        return resultHandler.apply(negative ? -num : num);
                    }
                    throw new IllegalStateException("LF is expected");
                }
            }
        }
        return partialHandler.partial(new LongPartial(negative, num, state));
    }

    <T> Parser<T> mapToParser(LongFunction<T> longFunction) {
        return new ParserAdaptor(this, longFunction);
    }

    private static class ParserAdaptor<T>
    implements Parser<T> {
        private final LongParser parser;
        private final LongFunction<T> longFunction;

        private ParserAdaptor(LongParser parser, LongFunction<T> longFunction) {
            this.parser = parser;
            this.longFunction = longFunction;
        }

        @Override
        public <U> U parse(ByteBuffer buffer, Function<? super T, U> resultHandler, Parser.PartialHandler<? super T, U> partialHandler, CharsetDecoder charsetDecoder) {
            return (U)this.parser.parse(buffer, value -> resultHandler.apply((T)this.longFunction.apply(value)), partial -> partialHandler.partial(new ParserAdaptor<T>(partial, this.longFunction)));
        }
    }

    private static class LongPartial
    extends LongParser {
        private final boolean negative;
        private final long num;
        private final int state;

        private LongPartial(boolean negative, long num, int state) {
            this.negative = negative;
            this.num = num;
            this.state = state;
        }

        @Override
        <T> T parse(ByteBuffer buffer, LongFunction<T> resultHandler, PartialHandler<T> partialHandler) {
            return (T)LongParser.doParse(buffer, resultHandler, partialHandler, this.negative, this.num, this.state);
        }
    }

    static interface PartialHandler<T> {
        public T partial(LongParser var1);
    }
}

